CREATE TABLE IF NOT EXISTS `__PREFIX__ezfc_debug` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `msg` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `__PREFIX__ezfc_forms` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT COLLATE="utf8_general_ci";

CREATE TABLE IF NOT EXISTS `__PREFIX__ezfc_forms_elements` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `f_id` int(10) unsigned NOT NULL,
  `e_id` int(10) unsigned NOT NULL,
  `data` text NOT NULL,
  `position` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `f_id` (`f_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT COLLATE="utf8_general_ci";

CREATE TABLE IF NOT EXISTS `__PREFIX__ezfc_forms_options` (
  `f_id` int(10) unsigned NOT NULL,
  `o_id` int(10) unsigned NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`f_id`,`o_id`)
) ENGINE=InnoDB DEFAULT COLLATE="utf8_general_ci";

CREATE TABLE IF NOT EXISTS `__PREFIX__ezfc_options` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `value` text NOT NULL,
  `description` text NOT NULL,
  `description_long` text NOT NULL,
  `type` text NOT NULL,
  `cat` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT COLLATE="utf8_general_ci";

CREATE TABLE IF NOT EXISTS `__PREFIX__ezfc_submissions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `f_id` int(10) unsigned NOT NULL,
  `data` mediumtext NOT NULL,
  `content` mediumtext NOT NULL,
  `date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `ip` varchar(50) NOT NULL,
  `ref_id` VARCHAR(16) NOT NULL,
  `total` DOUBLE NOT NULL,
  `payment_id` INT UNSIGNED NOT NULL DEFAULT '0',
  `transaction_id` VARCHAR(50) NOT NULL,
  `token` VARCHAR(20) NOT NULL,
  `user_mail` VARCHAR(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `f_id` (`f_id`)
) ENGINE=InnoDB DEFAULT COLLATE="utf8_general_ci";

CREATE TABLE IF NOT EXISTS `__PREFIX__ezfc_templates` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `data` text NOT NULL,
  `options` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT COLLATE="utf8_general_ci";

INSERT IGNORE INTO `__PREFIX__ezfc_templates` (`id`, `name`, `data`, `options`) VALUES
  (1, 'Website order', '{"10":{"id":"10","f_id":"2","e_id":"4","data":"{\\"e_id\\":\\"4\\",\\"name\\":\\"Logo\\",\\"label\\":\\"Do you need a logo?\\",\\"required\\":\\"1\\",\\"calculate_enabled\\":\\"1\\",\\"options\\":[{\\"value\\":\\"0\\",\\"text\\":\\"No\\"},{\\"value\\":\\"250\\",\\"text\\":\\"Yes, please.\\"}],\\"calculate\\":[{\\"operator\\":\\"0\\",\\"target\\":\\"0\\",\\"value\\":\\"\\"}],\\"overwrite_price\\":\\"0\\",\\"calculate_before\\":\\"0\\",\\"conditional\\":[{\\"action\\":\\"0\\",\\"target\\":\\"0\\",\\"operator\\":\\"0\\",\\"value\\":\\"\\"}],\\"class\\":\\"\\",\\"hidden\\":\\"0\\",\\"columns\\":\\"3\\"}","position":"10"},"12":{"id":"12","f_id":"2","e_id":"7","data":"{\\"e_id\\":\\"7\\",\\"name\\":\\"Sites\\",\\"label\\":\\"Sites\\",\\"required\\":\\"1\\",\\"calculate_enabled\\":\\"1\\",\\"factor\\":\\"40\\",\\"value\\":\\"\\",\\"min\\":\\"1\\",\\"max\\":\\"50\\",\\"calculate\\":[{\\"operator\\":\\"0\\",\\"target\\":\\"0\\",\\"value\\":\\"\\"}],\\"overwrite_price\\":\\"0\\",\\"calculate_before\\":\\"0\\",\\"conditional\\":[{\\"action\\":\\"0\\",\\"target\\":\\"0\\",\\"operator\\":\\"0\\",\\"value\\":\\"\\"}],\\"placeholder\\":\\"\\",\\"class\\":\\"\\",\\"hidden\\":\\"0\\",\\"columns\\":\\"3\\"}","position":"9"},"11":{"id":"11","f_id":"2","e_id":"5","data":"{\\"e_id\\":\\"5\\",\\"name\\":\\"CMS\\",\\"label\\":\\"Which cms do you prefer?\\",\\"required\\":\\"1\\",\\"calculate_enabled\\":\\"1\\",\\"options\\":[{\\"value\\":\\"250\\",\\"text\\":\\"WordPress\\"},{\\"value\\":\\"300\\",\\"text\\":\\"Joomla\\"},{\\"value\\":\\"250\\",\\"text\\":\\"Drupal\\"},{\\"value\\":\\"0\\",\\"text\\":\\"None\\"}],\\"calculate\\":[{\\"operator\\":\\"0\\",\\"target\\":\\"0\\",\\"value\\":\\"\\"}],\\"overwrite_price\\":\\"0\\",\\"calculate_before\\":\\"0\\",\\"conditional\\":[{\\"action\\":\\"0\\",\\"target\\":\\"0\\",\\"operator\\":\\"0\\",\\"value\\":\\"\\"}],\\"class\\":\\"\\",\\"hidden\\":\\"0\\",\\"columns\\":\\"3\\"}","position":"8"},"13":{"id":"13","f_id":"2","e_id":"6","data":"{\\"e_id\\":\\"6\\",\\"name\\":\\"Services\\",\\"label\\":\\"Additional services\\",\\"required\\":\\"0\\",\\"calculate_enabled\\":\\"1\\",\\"options\\":[{\\"value\\":\\"30\\",\\"text\\":\\"Google Analytics\\"},{\\"value\\":\\"250\\",\\"text\\":\\"Form Calculator\\"},{\\"value\\":\\"50\\",\\"text\\":\\"Contact form\\"}],\\"preselect\\":\\"\\",\\"calculate\\":[{\\"operator\\":\\"0\\",\\"target\\":\\"0\\",\\"value\\":\\"\\"}],\\"overwrite_price\\":\\"0\\",\\"calculate_before\\":\\"0\\",\\"conditional\\":[{\\"action\\":\\"0\\",\\"target\\":\\"0\\",\\"operator\\":\\"0\\",\\"value\\":\\"\\"}],\\"class\\":\\"\\",\\"hidden\\":\\"0\\",\\"columns\\":\\"3\\"}","position":"7"},"14":{"id":"14","f_id":"2","e_id":"11","data":"{\\"e_id\\":\\"11\\",\\"class\\":\\"\\",\\"hidden\\":\\"0\\",\\"columns\\":\\"6\\"}","position":"6"},"15":{"id":"15","f_id":"2","e_id":"2","data":"{\\"e_id\\":\\"2\\",\\"name\\":\\"Email\\",\\"label\\":\\"Email\\",\\"required\\":\\"1\\",\\"use_address\\":\\"1\\",\\"double_check\\":\\"0\\",\\"value\\":\\"\\",\\"placeholder\\":\\"your@email.com\\",\\"class\\":\\"\\",\\"hidden\\":\\"0\\",\\"columns\\":\\"6\\"}","position":"5"},"16":{"id":"16","f_id":"2","e_id":"8","data":"{\\"e_id\\":\\"8\\",\\"name\\":\\"Deadline\\",\\"label\\":\\"When is the deadline?\\",\\"required\\":\\"0\\",\\"value\\":\\"\\",\\"placeholder\\":\\"\\",\\"class\\":\\"\\",\\"hidden\\":\\"0\\",\\"columns\\":\\"6\\"}","position":"4"},"17":{"id":"17","f_id":"2","e_id":"3","data":"{\\"e_id\\":\\"3\\",\\"name\\":\\"Message\\",\\"label\\":\\"Message\\",\\"required\\":\\"0\\",\\"value\\":\\"\\",\\"placeholder\\":\\"Any more information about the website.\\",\\"class\\":\\"\\",\\"hidden\\":\\"0\\",\\"columns\\":\\"6\\"}","position":"3"},"18":{"id":"18","f_id":"2","e_id":"11","data":"{\\"e_id\\":\\"11\\",\\"class\\":\\"\\",\\"hidden\\":\\"0\\",\\"columns\\":\\"6\\"}","position":"2"},"19":{"id":"19","f_id":"2","e_id":"10","data":"{\\"e_id\\":\\"10\\",\\"name\\":\\"Hidden\\",\\"label\\":\\"\\",\\"required\\":\\"0\\",\\"calculate_enabled\\":\\"0\\",\\"calculate\\":[{\\"operator\\":\\"0\\",\\"target\\":\\"0\\",\\"value\\":\\"\\"}],\\"overwrite_price\\":\\"0\\",\\"factor\\":\\"\\",\\"value\\":\\"Some more hidden content.\\",\\"class\\":\\"\\",\\"GET\\":\\"\\",\\"hidden\\":\\"0\\",\\"columns\\":\\"6\\"}","position":"1"}}', ''),
  (2, 'Event calculator', '{"41":{"id":"41","f_id":"6","e_id":"7","data":"{\\"e_id\\":\\"7\\",\\"name\\":\\"Persons\\",\\"label\\":\\"Number of persons\\",\\"required\\":\\"1\\",\\"calculate_enabled\\":\\"1\\",\\"factor\\":\\"0\\",\\"value\\":\\"\\",\\"min\\":\\"50\\",\\"max\\":\\"0\\",\\"calculate\\":[{\\"operator\\":\\"0\\",\\"target\\":\\"0\\",\\"value\\":\\"\\"}],\\"overwrite_price\\":\\"0\\",\\"calculate_before\\":\\"0\\",\\"slider\\":\\"0\\",\\"placeholder\\":\\"100\\",\\"class\\":\\"\\"}","position":"9"},"43":{"id":"43","f_id":"6","e_id":"5","data":"{\\"e_id\\":\\"5\\",\\"name\\":\\"Catering\\",\\"label\\":\\"Catering\\",\\"required\\":\\"1\\",\\"calculate_enabled\\":\\"1\\",\\"options\\":[{\\"value\\":\\"0\\",\\"text\\":\\"None\\"},{\\"value\\":\\"10\\",\\"text\\":\\"Cold buffet\\"},{\\"value\\":\\"15\\",\\"text\\":\\"Warm buffet\\"},{\\"value\\":\\"25\\",\\"text\\":\\"Deluxe buffet\\"}],\\"calculate\\":[{\\"operator\\":\\"multiply\\",\\"target\\":\\"9\\",\\"value\\":\\"\\"}],\\"overwrite_price\\":\\"0\\",\\"calculate_before\\":\\"0\\",\\"class\\":\\"\\"}","position":"8"},"46":{"id":"46","f_id":"6","e_id":"4","data":"{\\"e_id\\":\\"4\\",\\"name\\":\\"Marquee\\",\\"label\\":\\"Marquee\\",\\"required\\":\\"1\\",\\"calculate_enabled\\":\\"1\\",\\"options\\":[{\\"value\\":\\"0\\",\\"text\\":\\"No\\"},{\\"value\\":\\"5\\",\\"text\\":\\"Yes\\"}],\\"preselect\\":\\"1\\",\\"calculate\\":[{\\"operator\\":\\"multiply\\",\\"target\\":\\"9\\",\\"value\\":\\"\\"}],\\"overwrite_price\\":\\"0\\",\\"calculate_before\\":\\"0\\",\\"conditional\\":[{\\"action\\":\\"0\\",\\"target\\":\\"0\\",\\"operator\\":\\"0\\",\\"value\\":\\"\\"}],\\"class\\":\\"\\"}","position":"7"},"47":{"id":"47","f_id":"6","e_id":"6","data":"{\\"e_id\\":\\"6\\",\\"name\\":\\"Services\\",\\"label\\":\\"Services\\",\\"required\\":\\"0\\",\\"calculate_enabled\\":\\"1\\",\\"options\\":[{\\"value\\":\\"150\\",\\"text\\":\\"DJ\\"},{\\"value\\":\\"500\\",\\"text\\":\\"Cocktail bar\\"},{\\"value\\":\\"666\\",\\"text\\":\\"Fireworks\\"}],\\"preselect\\":\\"\\",\\"calculate\\":[{\\"operator\\":\\"0\\",\\"target\\":\\"0\\",\\"value\\":\\"\\"}],\\"overwrite_price\\":\\"0\\",\\"calculate_before\\":\\"0\\",\\"conditional\\":[{\\"action\\":\\"0\\",\\"target\\":\\"0\\",\\"operator\\":\\"0\\",\\"value\\":\\"\\"}],\\"class\\":\\"\\"}","position":"6"},"48":{"id":"48","f_id":"6","e_id":"11","data":"{\\"e_id\\":\\"11\\",\\"class\\":\\"\\"}","position":"5"},"42":{"id":"42","f_id":"6","e_id":"1","data":"{\\"e_id\\":\\"1\\",\\"name\\":\\"Name\\",\\"label\\":\\"Name\\",\\"required\\":\\"1\\",\\"value\\":\\"\\",\\"placeholder\\":\\"\\",\\"class\\":\\"\\"}","position":"4"},"37":{"id":"37","f_id":"6","e_id":"2","data":"{\\"e_id\\":\\"2\\",\\"name\\":\\"Email\\",\\"label\\":\\"Email\\",\\"required\\":\\"1\\",\\"value\\":\\"\\",\\"placeholder\\":\\"Your email\\",\\"class\\":\\"\\"}","position":"3"},"38":{"id":"38","f_id":"6","e_id":"3","data":"{\\"e_id\\":\\"3\\",\\"name\\":\\"Message\\",\\"label\\":\\"Message\\",\\"required\\":\\"1\\",\\"value\\":\\"\\",\\"placeholder\\":\\"Your message\\",\\"class\\":\\"\\"}","position":"2"},"39":{"id":"39","f_id":"6","e_id":"8","data":"{\\"e_id\\":\\"8\\",\\"name\\":\\"Date\\",\\"label\\":\\"Event date\\",\\"required\\":\\"0\\",\\"value\\":\\"\\",\\"placeholder\\":\\"\\",\\"class\\":\\"\\"}","position":"1"}}', ''),
  (3, 'Photo Shooting', '{"20":{"id":"20","f_id":"3","e_id":"4","data":"{\\"e_id\\":\\"4\\",\\"name\\":\\"Product\\",\\"label\\":\\"Product\\",\\"required\\":\\"1\\",\\"calculate_enabled\\":\\"1\\",\\"options\\":[{\\"value\\":\\"75\\",\\"text\\":\\"Portrait\\"},{\\"value\\":\\"250\\",\\"text\\":\\"Indoor shooting\\"},{\\"value\\":\\"350\\",\\"text\\":\\"Outdoor shooting\\"}],\\"calculate\\":[{\\"operator\\":\\"0\\",\\"target\\":\\"0\\",\\"value\\":\\"\\"}],\\"overwrite_price\\":\\"0\\",\\"calculate_before\\":\\"0\\",\\"conditional\\":[{\\"action\\":\\"0\\",\\"target\\":\\"0\\",\\"operator\\":\\"0\\",\\"value\\":\\"\\"}],\\"class\\":\\"\\",\\"hidden\\":\\"0\\",\\"columns\\":\\"3\\"}","position":"8"},"21":{"id":"21","f_id":"3","e_id":"6","data":"{\\"e_id\\":\\"6\\",\\"name\\":\\"Services\\",\\"label\\":\\"Additional services\\",\\"required\\":\\"0\\",\\"calculate_enabled\\":\\"1\\",\\"options\\":[{\\"value\\":\\"1250\\",\\"text\\":\\"Exclusive rights\\"},{\\"value\\":\\"25\\",\\"text\\":\\"DVD\\"}],\\"preselect\\":\\"\\",\\"calculate\\":[{\\"operator\\":\\"0\\",\\"target\\":\\"0\\",\\"value\\":\\"\\"}],\\"overwrite_price\\":\\"0\\",\\"calculate_before\\":\\"0\\",\\"conditional\\":[{\\"action\\":\\"0\\",\\"target\\":\\"0\\",\\"operator\\":\\"0\\",\\"value\\":\\"\\"}],\\"class\\":\\"\\",\\"hidden\\":\\"0\\",\\"columns\\":\\"3\\"}","position":"7"},"22":{"id":"22","f_id":"3","e_id":"11","data":"{\\"e_id\\":\\"11\\",\\"class\\":\\"\\",\\"hidden\\":\\"0\\",\\"columns\\":\\"6\\"}","position":"6"},"23":{"id":"23","f_id":"3","e_id":"1","data":"{\\"e_id\\":\\"1\\",\\"name\\":\\"Name\\",\\"label\\":\\"Name\\",\\"required\\":\\"1\\",\\"value\\":\\"\\",\\"placeholder\\":\\"Your name\\",\\"class\\":\\"\\",\\"hidden\\":\\"0\\",\\"columns\\":\\"6\\"}","position":"5"},"24":{"id":"24","f_id":"3","e_id":"2","data":"{\\"e_id\\":\\"2\\",\\"name\\":\\"Email\\",\\"label\\":\\"Email\\",\\"required\\":\\"1\\",\\"use_address\\":\\"1\\",\\"double_check\\":\\"1\\",\\"value\\":\\"\\",\\"placeholder\\":\\"your@email.com\\",\\"class\\":\\"\\",\\"hidden\\":\\"0\\",\\"columns\\":\\"6\\"}","position":"4"},"25":{"id":"25","f_id":"3","e_id":"3","data":"{\\"e_id\\":\\"3\\",\\"name\\":\\"Message\\",\\"label\\":\\"Message\\",\\"required\\":\\"0\\",\\"value\\":\\"\\",\\"placeholder\\":\\"Your message\\",\\"class\\":\\"\\",\\"hidden\\":\\"0\\",\\"columns\\":\\"6\\"}","position":"3"},"26":{"id":"26","f_id":"3","e_id":"8","data":"{\\"e_id\\":\\"8\\",\\"name\\":\\"Date\\",\\"label\\":\\"Date\\",\\"required\\":\\"0\\",\\"value\\":\\"\\",\\"placeholder\\":\\"\\",\\"class\\":\\"\\",\\"hidden\\":\\"0\\",\\"columns\\":\\"6\\"}","position":"2"},"27":{"id":"27","f_id":"3","e_id":"11","data":"{\\"e_id\\":\\"11\\",\\"class\\":\\"\\",\\"hidden\\":\\"0\\",\\"columns\\":\\"6\\"}","position":"1"}}', ''),
  (4, 'Miles to km conversion', '[{"id":"21","f_id":"5","e_id":"7","data":"{\\"e_id\\":\\"7\\",\\"name\\":\\"Miles\\",\\"label\\":\\"Miles\\",\\"required\\":\\"1\\",\\"calculate_enabled\\":\\"1\\",\\"factor\\":\\"1.609344\\",\\"value\\":\\"\\",\\"min\\":\\"\\",\\"max\\":\\"\\",\\"calculate\\":{\\"operator\\":\\"0\\",\\"target\\":\\"0\\"},\\"placeholder\\":\\"\\",\\"class\\":\\"\\"}","position":"1"}]', ''),
  (5, 'Conditional Example', '{"761":{"id":"761","f_id":"49","e_id":"5","data":"{\\"e_id\\":\\"5\\",\\"name\\":\\"Radio\\",\\"label\\":\\"Radio\\",\\"required\\":\\"0\\",\\"calculate_enabled\\":\\"1\\",\\"options\\":[{\\"value\\":\\"0\\",\\"text\\":\\"A\\"},{\\"value\\":\\"1\\",\\"text\\":\\"B\\"}],\\"calculate\\":[{\\"operator\\":\\"0\\",\\"target\\":\\"0\\",\\"value\\":\\"\\"}],\\"overwrite_price\\":\\"0\\",\\"calculate_before\\":\\"0\\",\\"conditional\\":[{\\"action\\":\\"show\\",\\"target\\":\\"4\\",\\"operator\\":\\"equals\\",\\"value\\":\\"0\\"},{\\"action\\":\\"show\\",\\"target\\":\\"2\\",\\"operator\\":\\"equals\\",\\"value\\":\\"1\\"},{\\"action\\":\\"show\\",\\"target\\":\\"3\\",\\"operator\\":\\"equals\\",\\"value\\":\\"0\\"},{\\"action\\":\\"show\\",\\"target\\":\\"1\\",\\"operator\\":\\"equals\\",\\"value\\":\\"1\\"}],\\"discount\\":[{\\"range_min\\":\\"\\",\\"range_max\\":\\"\\",\\"operator\\":\\"0\\",\\"discount_value\\":\\"\\"}],\\"class\\":\\"\\",\\"hidden\\":\\"0\\",\\"columns\\":\\"6\\",\\"description\\":\\"\\"}","position":"5"},"762":{"id":"762","f_id":"49","e_id":"5","data":"{\\"e_id\\":\\"5\\",\\"name\\":\\"Radio A\\",\\"label\\":\\"Radio A\\",\\"required\\":\\"0\\",\\"calculate_enabled\\":\\"1\\",\\"options\\":[{\\"value\\":\\"10\\",\\"text\\":\\"A1\\"},{\\"value\\":\\"20\\",\\"text\\":\\"A2\\"}],\\"calculate\\":[{\\"operator\\":\\"0\\",\\"target\\":\\"0\\",\\"value\\":\\"\\"}],\\"overwrite_price\\":\\"0\\",\\"calculate_before\\":\\"0\\",\\"conditional\\":[{\\"action\\":\\"0\\",\\"target\\":\\"0\\",\\"operator\\":\\"0\\",\\"value\\":\\"\\"}],\\"discount\\":[{\\"range_min\\":\\"\\",\\"range_max\\":\\"\\",\\"operator\\":\\"0\\",\\"discount_value\\":\\"\\"}],\\"class\\":\\"\\",\\"hidden\\":\\"0\\",\\"columns\\":\\"6\\",\\"description\\":\\"\\"}","position":"4"},"763":{"id":"763","f_id":"49","e_id":"7","data":"{\\"e_id\\":\\"7\\",\\"name\\":\\"Numbers A\\",\\"label\\":\\"Numbers A\\",\\"required\\":\\"0\\",\\"calculate_enabled\\":\\"1\\",\\"factor\\":\\"\\",\\"value\\":\\"\\",\\"value_external\\":\\"\\",\\"min\\":\\"0\\",\\"max\\":\\"100\\",\\"slider\\":\\"0\\",\\"steps_slider\\":\\"1\\",\\"spinner\\":\\"0\\",\\"steps_spinner\\":\\"1\\",\\"calculate\\":[{\\"operator\\":\\"0\\",\\"target\\":\\"0\\",\\"value\\":\\"\\"}],\\"overwrite_price\\":\\"1\\",\\"calculate_before\\":\\"0\\",\\"conditional\\":[{\\"action\\":\\"0\\",\\"target\\":\\"0\\",\\"operator\\":\\"0\\",\\"value\\":\\"\\"}],\\"discount\\":[{\\"range_min\\":\\"\\",\\"range_max\\":\\"\\",\\"operator\\":\\"0\\",\\"discount_value\\":\\"\\"}],\\"placeholder\\":\\"\\",\\"class\\":\\"\\",\\"hidden\\":\\"0\\",\\"columns\\":\\"6\\",\\"description\\":\\"\\"}","position":"3"},"764":{"id":"764","f_id":"49","e_id":"5","data":"{\\"e_id\\":\\"5\\",\\"name\\":\\"Radio B\\",\\"label\\":\\"Radio B\\",\\"required\\":\\"0\\",\\"calculate_enabled\\":\\"1\\",\\"options\\":[{\\"value\\":\\"30\\",\\"text\\":\\"B1\\"},{\\"value\\":\\"40\\",\\"text\\":\\"B2\\"}],\\"calculate\\":[{\\"operator\\":\\"0\\",\\"target\\":\\"0\\",\\"value\\":\\"\\"}],\\"overwrite_price\\":\\"0\\",\\"calculate_before\\":\\"0\\",\\"conditional\\":[{\\"action\\":\\"0\\",\\"target\\":\\"0\\",\\"operator\\":\\"0\\",\\"value\\":\\"\\"}],\\"discount\\":[{\\"range_min\\":\\"\\",\\"range_max\\":\\"\\",\\"operator\\":\\"0\\",\\"discount_value\\":\\"\\"}],\\"class\\":\\"\\",\\"hidden\\":\\"0\\",\\"columns\\":\\"6\\",\\"description\\":\\"\\"}","position":"2"},"765":{"id":"765","f_id":"49","e_id":"7","data":"{\\"e_id\\":\\"7\\",\\"name\\":\\"Numbers B\\",\\"label\\":\\"Numbers B\\",\\"required\\":\\"0\\",\\"calculate_enabled\\":\\"1\\",\\"factor\\":\\"\\",\\"value\\":\\"\\",\\"value_external\\":\\"\\",\\"min\\":\\"0\\",\\"max\\":\\"100\\",\\"slider\\":\\"0\\",\\"steps_slider\\":\\"1\\",\\"spinner\\":\\"0\\",\\"steps_spinner\\":\\"1\\",\\"calculate\\":[{\\"operator\\":\\"0\\",\\"target\\":\\"0\\",\\"value\\":\\"\\"}],\\"overwrite_price\\":\\"0\\",\\"calculate_before\\":\\"0\\",\\"conditional\\":[{\\"action\\":\\"0\\",\\"target\\":\\"0\\",\\"operator\\":\\"0\\",\\"value\\":\\"\\"}],\\"discount\\":[{\\"range_min\\":\\"\\",\\"range_max\\":\\"\\",\\"operator\\":\\"0\\",\\"discount_value\\":\\"\\"}],\\"placeholder\\":\\"\\",\\"class\\":\\"\\",\\"hidden\\":\\"0\\",\\"columns\\":\\"6\\",\\"description\\":\\"\\"}","position":"1"}}', ''),
  (6, 'Email text example', '{"316":{"id":"316","f_id":"32","e_id":"4","data":"{\\"e_id\\":\\"4\\",\\"name\\":\\"Title\\",\\"label\\":\\"Title\\",\\"required\\":\\"1\\",\\"calculate_enabled\\":\\"1\\",\\"is_currency\\":\\"1\\",\\"options\\":[{\\"value\\":\\"Ms\\",\\"text\\":\\"Ms\\"},{\\"value\\":\\"Mr\\",\\"text\\":\\"Mr\\"}],\\"calculate\\":[{\\"operator\\":\\"0\\",\\"target\\":\\"0\\",\\"value\\":\\"\\"}],\\"overwrite_price\\":\\"0\\",\\"calculate_before\\":\\"0\\",\\"conditional\\":[{\\"action\\":\\"0\\",\\"target\\":\\"0\\",\\"operator\\":\\"0\\",\\"value\\":\\"\\"}],\\"discount\\":[{\\"range_min\\":\\"\\",\\"range_max\\":\\"\\",\\"operator\\":\\"0\\",\\"discount_value\\":\\"\\"}],\\"show_in_email\\":\\"1\\",\\"class\\":\\"\\",\\"style\\":\\"\\",\\"hidden\\":\\"0\\",\\"columns\\":\\"1\\"}","position":"5"},"317":{"id":"317","f_id":"32","e_id":"1","data":"{\\"e_id\\":\\"1\\",\\"name\\":\\"Name\\",\\"label\\":\\"Name\\",\\"required\\":\\"1\\",\\"value\\":\\"\\",\\"value_external\\":\\"\\",\\"placeholder\\":\\"\\",\\"custom_regex\\":\\"\\",\\"custom_error_message\\":\\"\\",\\"show_in_email\\":\\"1\\",\\"class\\":\\"\\",\\"style\\":\\"\\",\\"hidden\\":\\"0\\",\\"columns\\":\\"5\\"}","position":"4"},"318":{"id":"318","f_id":"32","e_id":"4","data":"{\\"e_id\\":\\"4\\",\\"name\\":\\"Product\\",\\"label\\":\\"Product\\",\\"required\\":\\"1\\",\\"calculate_enabled\\":\\"1\\",\\"is_currency\\":\\"1\\",\\"options\\":[{\\"value\\":\\"100\\",\\"text\\":\\"Product 1\\"},{\\"value\\":\\"200\\",\\"text\\":\\"Product 2\\"}],\\"calculate\\":[{\\"operator\\":\\"0\\",\\"target\\":\\"0\\",\\"value\\":\\"\\"}],\\"overwrite_price\\":\\"0\\",\\"calculate_before\\":\\"0\\",\\"conditional\\":[{\\"action\\":\\"0\\",\\"target\\":\\"0\\",\\"operator\\":\\"0\\",\\"value\\":\\"\\"}],\\"discount\\":[{\\"range_min\\":\\"\\",\\"range_max\\":\\"\\",\\"operator\\":\\"0\\",\\"discount_value\\":\\"\\"}],\\"show_in_email\\":\\"1\\",\\"class\\":\\"\\",\\"style\\":\\"\\",\\"hidden\\":\\"0\\",\\"columns\\":\\"6\\"}","position":"3"},"319":{"id":"319","f_id":"32","e_id":"6","data":"{\\"e_id\\":\\"6\\",\\"name\\":\\"Services\\",\\"label\\":\\"Services\\",\\"required\\":\\"0\\",\\"calculate_enabled\\":\\"1\\",\\"is_currency\\":\\"1\\",\\"options\\":[{\\"value\\":\\"100\\",\\"text\\":\\"Service 1\\"},{\\"value\\":\\"200\\",\\"text\\":\\"Service 2\\"}],\\"preselect\\":\\"\\",\\"calculate\\":[{\\"operator\\":\\"0\\",\\"target\\":\\"0\\",\\"value\\":\\"\\"}],\\"overwrite_price\\":\\"0\\",\\"calculate_before\\":\\"0\\",\\"conditional\\":[{\\"action\\":\\"0\\",\\"target\\":\\"0\\",\\"operator\\":\\"0\\",\\"value\\":\\"\\"}],\\"discount\\":[{\\"range_min\\":\\"\\",\\"range_max\\":\\"\\",\\"operator\\":\\"0\\",\\"discount_value\\":\\"\\"}],\\"show_in_email\\":\\"1\\",\\"class\\":\\"\\",\\"style\\":\\"\\",\\"hidden\\":\\"0\\",\\"columns\\":\\"6\\"}","position":"2"},"320":{"id":"320","f_id":"32","e_id":"2","data":"{\\"e_id\\":\\"2\\",\\"name\\":\\"Email\\",\\"label\\":\\"Email\\",\\"required\\":\\"0\\",\\"use_address\\":\\"1\\",\\"double_check\\":\\"0\\",\\"value\\":\\"pansensalat@gmail.com\\",\\"value_external\\":\\"\\",\\"placeholder\\":\\"\\",\\"show_in_email\\":\\"1\\",\\"class\\":\\"\\",\\"style\\":\\"\\",\\"hidden\\":\\"0\\",\\"columns\\":\\"6\\"}","position":"1"}}', '[{"f_id":"32","o_id":"1","value":"","name":"email_recipient","type":""},{"f_id":"32","o_id":"2","value":"Thank you for your submission!","name":"success_text","type":""},{"f_id":"32","o_id":"3","value":"1","name":"spam_time","type":""},{"f_id":"32","o_id":"4","value":"1","name":"show_required_char","type":"yesno"},{"f_id":"32","o_id":"5","value":"$","name":"currency","type":""},{"f_id":"32","o_id":"6","value":"Price","name":"price_label","type":""},{"f_id":"32","o_id":"7","value":"0","name":"show_element_price","type":"yesno"},{"f_id":"32","o_id":"8","value":"1","name":"submission_enabled","type":"yesno"},{"f_id":"32","o_id":"9","value":"1","name":"show_price_position","type":"select,Hidden|Below|Above|Below and above|Fixed left|Fixed right"},{"f_id":"32","o_id":"10","value":"","name":"email_admin_sender","type":""},{"f_id":"32","o_id":"11","value":"Your submission","name":"email_subject","type":""},{"f_id":"32","o_id":"12","value":"Dear {{title}} {{name}},\\r\\n\\r\\nthank you for your submission, you have selected the following products:\\r\\n\\r\\n<strong>Product: {{product}}\\r\\n<\\/strong><strong>Additional services: {{services}}<\\/strong>\\r\\n\\r\\nWe will contact you soon!\\r\\n\\r\\nBest regards\\r\\nez Form Calculator","name":"email_text","type":"editor"},{"f_id":"32","o_id":"13","value":"New submission","name":"email_admin_subject","type":""},{"f_id":"32","o_id":"14","value":"You have received a new submission:\\r\\n\\r\\n{{result}}","name":"email_admin_text","type":"editor"},{"f_id":"32","o_id":"15","value":"Submit","name":"submit_text","type":""},{"f_id":"32","o_id":"16","value":"Add to cart","name":"submit_text_woo","type":""},{"f_id":"32","o_id":"17","value":"","name":"submit_button_class","type":""},{"f_id":"32","o_id":"18","value":"1","name":"email_show_total_price","type":"yesno"},{"f_id":"32","o_id":"19","value":"default","name":"theme","type":"themes"},{"f_id":"32","o_id":"20","value":"0","name":"currency_position","type":"select,Before|After"},{"f_id":"32","o_id":"21","value":"mm\\/dd\\/yy","name":"datepicker_format","type":""},{"f_id":"32","o_id":"22","value":"0","name":"pp_enabled","type":"yesno"},{"f_id":"32","o_id":"23","value":"Check out with PayPal","name":"pp_submittext","type":""},{"f_id":"32","o_id":"24","value":"Your submission","name":"email_subject_pp","type":""},{"f_id":"32","o_id":"25","value":"Thank you for your submission,\\r\\n\\r\\nwe have received your payment via PayPal.","name":"email_text_pp","type":"editor"},{"f_id":"32","o_id":"26","value":"We have received your payment, thank you!","name":"pp_paid_text","type":""},{"f_id":"32","o_id":"27","value":"","name":"redirect_url","type":""},{"f_id":"32","o_id":"28","value":"1","name":"min_submit_value","type":""},{"f_id":"32","o_id":"29","value":"Your total value is 0. Please choose a product.","name":"min_submit_value_text","type":""},{"f_id":"32","o_id":"30","value":"1","name":"mailchimp_add","type":"yesno"},{"f_id":"32","o_id":"31","value":"-1","name":"mailchimp_list","type":"mailchimp_list"},{"f_id":"32","o_id":"32","value":"0","name":"hide_all_forms","type":"yesno"},{"f_id":"32","o_id":"33","value":"H:i","name":"timepicker_format","type":""},{"f_id":"32","o_id":"34","value":"","name":"price_format","type":""},{"f_id":"32","o_id":"35","value":"","name":"woo_product_id","type":""}]'),
  (7, '(x + y) / z', '{"6":{"id":"6","f_id":"2","e_id":"7","data":"{\\"e_id\\":\\"7\\",\\"name\\":\\"x\\",\\"label\\":\\"x\\",\\"required\\":\\"0\\",\\"calculate_enabled\\":\\"1\\",\\"factor\\":\\"\\",\\"value\\":\\"\\",\\"min\\":\\"\\",\\"max\\":\\"\\",\\"calculate\\":[{\\"operator\\":\\"0\\",\\"target\\":\\"0\\",\\"value\\":\\"\\"}],\\"overwrite_price\\":\\"0\\",\\"calculate_before\\":\\"0\\",\\"conditional\\":[{\\"action\\":\\"0\\",\\"target\\":\\"0\\",\\"operator\\":\\"0\\",\\"value\\":\\"\\"}],\\"placeholder\\":\\"\\",\\"class\\":\\"\\",\\"hidden\\":\\"0\\",\\"columns\\":\\"6\\"}","position":"4"},"7":{"id":"7","f_id":"2","e_id":"7","data":"{\\"e_id\\":\\"7\\",\\"name\\":\\"y\\",\\"label\\":\\"y\\",\\"required\\":\\"0\\",\\"calculate_enabled\\":\\"1\\",\\"factor\\":\\"\\",\\"value\\":\\"\\",\\"min\\":\\"\\",\\"max\\":\\"\\",\\"calculate\\":[{\\"operator\\":\\"0\\",\\"target\\":\\"0\\",\\"value\\":\\"\\"}],\\"overwrite_price\\":\\"0\\",\\"calculate_before\\":\\"0\\",\\"conditional\\":[{\\"action\\":\\"0\\",\\"target\\":\\"0\\",\\"operator\\":\\"0\\",\\"value\\":\\"\\"}],\\"placeholder\\":\\"\\",\\"class\\":\\"\\",\\"hidden\\":\\"0\\",\\"columns\\":\\"6\\"}","position":"3"},"8":{"id":"8","f_id":"2","e_id":"7","data":"{\\"e_id\\":\\"7\\",\\"name\\":\\"z\\",\\"label\\":\\"z\\",\\"required\\":\\"0\\",\\"calculate_enabled\\":\\"1\\",\\"factor\\":\\"\\",\\"value\\":\\"\\",\\"min\\":\\"\\",\\"max\\":\\"\\",\\"calculate\\":[{\\"operator\\":\\"0\\",\\"target\\":\\"0\\",\\"value\\":\\"\\"}],\\"overwrite_price\\":\\"0\\",\\"calculate_before\\":\\"0\\",\\"conditional\\":[{\\"action\\":\\"0\\",\\"target\\":\\"0\\",\\"operator\\":\\"0\\",\\"value\\":\\"\\"}],\\"placeholder\\":\\"\\",\\"class\\":\\"\\",\\"hidden\\":\\"0\\",\\"columns\\":\\"6\\"}","position":"2"},"10":{"id":"10","f_id":"2","e_id":"15","data":"{\\"e_id\\":\\"15\\",\\"name\\":\\"Subtotal\\",\\"label\\":\\"Subtotal\\",\\"calculate_enabled\\":\\"1\\",\\"calculate\\":[{\\"operator\\":\\"equals\\",\\"target\\":\\"4\\",\\"value\\":\\"\\"},{\\"operator\\":\\"add\\",\\"target\\":\\"3\\",\\"value\\":\\"\\"},{\\"operator\\":\\"divide\\",\\"target\\":\\"2\\",\\"value\\":\\"\\"}],\\"overwrite_price\\":\\"1\\",\\"conditional\\":[{\\"action\\":\\"0\\",\\"target\\":\\"0\\",\\"operator\\":\\"0\\",\\"value\\":\\"\\"}],\\"class\\":\\"\\",\\"hidden\\":\\"1\\",\\"columns\\":\\"6\\"}","position":"1"}}', ''),
  (8, 'ezplugins.de - Form Sample', '{"701":{"id":"701","f_id":"41","e_id":"4","data":"{\\"name\\":\\"Plugin already purchased\\",\\"label\\":\\"Have you already purchased the plugin?\\",\\"required\\":\\"0\\",\\"calculate_enabled\\":\\"0\\",\\"options\\":[{\\"value\\":\\"0\\",\\"text\\":\\"No\\"},{\\"value\\":\\"1\\",\\"text\\":\\"Yes\\"}],\\"calculate\\":[{\\"operator\\":\\"0\\",\\"target\\":\\"0\\",\\"value\\":\\"\\"}],\\"overwrite_price\\":\\"0\\",\\"calculate_before\\":\\"0\\",\\"conditional\\":[{\\"action\\":\\"show\\",\\"target\\":\\"13\\",\\"operator\\":\\"equals\\",\\"value\\":\\"0\\"},{\\"action\\":\\"show\\",\\"target\\":\\"12\\",\\"operator\\":\\"equals\\",\\"value\\":\\"1\\"}],\\"discount\\":[{\\"range_min\\":\\"\\",\\"range_max\\":\\"\\",\\"operator\\":\\"0\\",\\"discount_value\\":\\"\\"}],\\"class\\":\\"\\",\\"hidden\\":\\"0\\",\\"columns\\":\\"2\\",\\"e_id\\":\\"4\\",\\"description\\":\\"\\"}","position":"14"},"702":{"id":"702","f_id":"41","e_id":"12","data":"{\\"name\\":\\"Purchase info\\",\\"html\\":\\"You can purchase the plugin on CodeCanyon.\\\\r\\\\n\\\\r\\\\n<a href=\\\\\\"http:\\\\\\/\\\\\\/codecanyon.net\\\\\\/item\\\\\\/ez-form-calculator-wordpress-plugin\\\\\\/7595334?ref=keksdieb\\\\\\" target=\\\\\\"_blank\\\\\\" class=\\\\\\"btn btn-primary\\\\\\">Purchase on CodeCanyon<\\\\\\/a>\\",\\"hidden\\":\\"0\\",\\"columns\\":\\"2\\",\\"e_id\\":\\"12\\"}","position":"13"},"703":{"id":"703","f_id":"41","e_id":"1","data":"{\\"name\\":\\"Purchase Code\\",\\"label\\":\\"Purchase Code\\",\\"required\\":\\"0\\",\\"value\\":\\"\\",\\"placeholder\\":\\"\\",\\"class\\":\\"\\",\\"hidden\\":\\"0\\",\\"columns\\":\\"2\\",\\"e_id\\":\\"1\\",\\"value_external\\":\\"\\",\\"description\\":\\"\\"}","position":"12"},"704":{"id":"704","f_id":"41","e_id":"11","data":"{\\"class\\":\\"\\",\\"hidden\\":\\"0\\",\\"columns\\":\\"6\\",\\"e_id\\":\\"11\\"}","position":"11"},"705":{"id":"705","f_id":"41","e_id":"5","data":"{\\"name\\":\\"Number of elements\\",\\"label\\":\\"Estimated number of elements needed\\",\\"required\\":\\"1\\",\\"calculate_enabled\\":\\"1\\",\\"options\\":[{\\"value\\":\\"15\\",\\"text\\":\\"1-3\\"},{\\"value\\":\\"25\\",\\"text\\":\\"4-6\\"},{\\"value\\":\\"35\\",\\"text\\":\\"7-9\\"},{\\"value\\":\\"50\\",\\"text\\":\\">=10\\"}],\\"calculate\\":[{\\"operator\\":\\"0\\",\\"target\\":\\"0\\",\\"value\\":\\"\\"}],\\"overwrite_price\\":\\"0\\",\\"calculate_before\\":\\"0\\",\\"conditional\\":[{\\"action\\":\\"show\\",\\"target\\":\\"9\\",\\"operator\\":\\"gre\\",\\"value\\":\\"0\\"}],\\"discount\\":[{\\"range_min\\":\\"\\",\\"range_max\\":\\"\\",\\"operator\\":\\"0\\",\\"discount_value\\":\\"\\"}],\\"class\\":\\"\\",\\"hidden\\":\\"0\\",\\"columns\\":\\"2\\",\\"e_id\\":\\"5\\",\\"description\\":\\"\\"}","position":"10"},"706":{"id":"706","f_id":"41","e_id":"4","data":"{\\"name\\":\\"Conditional elements\\",\\"label\\":\\"Do you need conditional elements?\\",\\"required\\":\\"1\\",\\"calculate_enabled\\":\\"0\\",\\"options\\":[{\\"value\\":\\"0\\",\\"text\\":\\"No\\"},{\\"value\\":\\"1\\",\\"text\\":\\"Yes\\"}],\\"calculate\\":[{\\"operator\\":\\"0\\",\\"target\\":\\"0\\",\\"value\\":\\"\\"}],\\"overwrite_price\\":\\"0\\",\\"calculate_before\\":\\"0\\",\\"conditional\\":[{\\"action\\":\\"show\\",\\"target\\":\\"8\\",\\"operator\\":\\"equals\\",\\"value\\":\\"1\\"}],\\"discount\\":[{\\"range_min\\":\\"\\",\\"range_max\\":\\"\\",\\"operator\\":\\"0\\",\\"discount_value\\":\\"\\"}],\\"class\\":\\"\\",\\"hidden\\":\\"0\\",\\"columns\\":\\"2\\",\\"e_id\\":\\"4\\",\\"description\\":\\"\\"}","position":"9"},"707":{"id":"707","f_id":"41","e_id":"5","data":"{\\"name\\":\\"Conditional elements number\\",\\"label\\":\\"Estimated number of conditional elements\\",\\"required\\":\\"0\\",\\"calculate_enabled\\":\\"1\\",\\"options\\":[{\\"value\\":\\"5\\",\\"text\\":\\"1-3\\"},{\\"value\\":\\"10\\",\\"text\\":\\"4-6\\"},{\\"value\\":\\"20\\",\\"text\\":\\">=7\\"}],\\"calculate\\":[{\\"operator\\":\\"0\\",\\"target\\":\\"0\\",\\"value\\":\\"\\"}],\\"overwrite_price\\":\\"0\\",\\"calculate_before\\":\\"0\\",\\"conditional\\":[{\\"action\\":\\"0\\",\\"target\\":\\"0\\",\\"operator\\":\\"0\\",\\"value\\":\\"\\"}],\\"discount\\":[{\\"range_min\\":\\"\\",\\"range_max\\":\\"\\",\\"operator\\":\\"0\\",\\"discount_value\\":\\"\\"}],\\"class\\":\\"\\",\\"hidden\\":\\"1\\",\\"columns\\":\\"2\\",\\"e_id\\":\\"5\\",\\"description\\":\\"\\"}","position":"8"},"708":{"id":"708","f_id":"41","e_id":"11","data":"{\\"class\\":\\"\\",\\"hidden\\":\\"0\\",\\"columns\\":\\"6\\",\\"e_id\\":\\"11\\"}","position":"7"},"709":{"id":"709","f_id":"41","e_id":"5","data":"{\\"name\\":\\"Turnaround\\",\\"label\\":\\"I need the form...\\",\\"required\\":\\"0\\",\\"calculate_enabled\\":\\"1\\",\\"options\\":[{\\"value\\":\\"35\\",\\"text\\":\\"... within 3 days\\"},{\\"value\\":\\"15\\",\\"text\\":\\"... within 7 days\\"},{\\"value\\":\\"0\\",\\"text\\":\\"... within 14 days\\"}],\\"calculate\\":[{\\"operator\\":\\"equals\\",\\"target\\":\\"10\\",\\"value\\":\\"\\"},{\\"operator\\":\\"add\\",\\"target\\":\\"8\\",\\"value\\":\\"\\"},{\\"operator\\":\\"multiply\\",\\"target\\":\\"6\\",\\"value\\":\\"\\"},{\\"operator\\":\\"divide\\",\\"target\\":\\"0\\",\\"value\\":\\"5\\"}],\\"overwrite_price\\":\\"0\\",\\"calculate_before\\":\\"0\\",\\"conditional\\":[{\\"action\\":\\"0\\",\\"target\\":\\"0\\",\\"operator\\":\\"0\\",\\"value\\":\\"\\"}],\\"discount\\":[{\\"range_min\\":\\"\\",\\"range_max\\":\\"\\",\\"operator\\":\\"0\\",\\"discount_value\\":\\"\\"}],\\"class\\":\\"\\",\\"hidden\\":\\"0\\",\\"columns\\":\\"2\\",\\"e_id\\":\\"5\\",\\"description\\":\\"\\"}","position":"6"},"710":{"id":"710","f_id":"41","e_id":"6","data":"{\\"name\\":\\"Additional options\\",\\"label\\":\\"Additional options\\",\\"required\\":\\"0\\",\\"calculate_enabled\\":\\"1\\",\\"options\\":[{\\"value\\":\\"10\\",\\"text\\":\\"Installation (we will install the form on your website)\\"},{\\"value\\":\\"15\\",\\"text\\":\\"Custom styling\\"},{\\"value\\":\\"100\\",\\"text\\":\\"Custom plugin features\\"},{\\"value\\":\\"-1\\",\\"text\\":\\"I have a dog\\"}],\\"calculate\\":[{\\"operator\\":\\"0\\",\\"target\\":\\"0\\",\\"value\\":\\"\\"}],\\"overwrite_price\\":\\"0\\",\\"calculate_before\\":\\"0\\",\\"conditional\\":[{\\"action\\":\\"0\\",\\"target\\":\\"0\\",\\"operator\\":\\"0\\",\\"value\\":\\"\\"}],\\"discount\\":[{\\"range_min\\":\\"\\",\\"range_max\\":\\"\\",\\"operator\\":\\"0\\",\\"discount_value\\":\\"\\"}],\\"class\\":\\"\\",\\"hidden\\":\\"0\\",\\"columns\\":\\"4\\",\\"e_id\\":\\"6\\",\\"preselect\\":\\"\\",\\"description\\":\\"\\"}","position":"5"},"711":{"id":"711","f_id":"41","e_id":"11","data":"{\\"class\\":\\"\\",\\"hidden\\":\\"0\\",\\"columns\\":\\"6\\",\\"e_id\\":\\"11\\"}","position":"4"},"712":{"id":"712","f_id":"41","e_id":"1","data":"{\\"name\\":\\"Name\\",\\"label\\":\\"\\",\\"required\\":\\"1\\",\\"value\\":\\"\\",\\"placeholder\\":\\"Name\\",\\"class\\":\\"\\",\\"hidden\\":\\"0\\",\\"columns\\":\\"3\\",\\"e_id\\":\\"1\\",\\"value_external\\":\\"\\",\\"description\\":\\"\\"}","position":"3"},"713":{"id":"713","f_id":"41","e_id":"2","data":"{\\"name\\":\\"Email\\",\\"label\\":\\"\\",\\"required\\":\\"1\\",\\"use_address\\":\\"1\\",\\"double_check\\":\\"0\\",\\"value\\":\\"\\",\\"placeholder\\":\\"Email address\\",\\"class\\":\\"\\",\\"hidden\\":\\"0\\",\\"columns\\":\\"3\\",\\"e_id\\":\\"2\\",\\"value_external\\":\\"\\",\\"description\\":\\"\\"}","position":"2"},"714":{"id":"714","f_id":"41","e_id":"3","data":"{\\"name\\":\\"Details\\",\\"label\\":\\"\\",\\"required\\":\\"0\\",\\"value\\":\\"\\",\\"placeholder\\":\\"Information about the form\\",\\"class\\":\\"\\",\\"hidden\\":\\"0\\",\\"columns\\":\\"6\\",\\"e_id\\":\\"3\\",\\"value_external\\":\\"\\",\\"description\\":\\"\\"}","position":"1"}}', ''),
  (9, 'Steps Example', '{"127":{"id":"127","f_id":"11","e_id":"18","data":"{\\"e_id\\":\\"18\\",\\"name\\":\\"Step #1\\",\\"class\\":\\"\\",\\"columns\\":\\"6\\"}","position":"10"},"132":{"id":"132","f_id":"11","e_id":"12","data":"{\\"e_id\\":\\"12\\",\\"name\\":\\"HTML\\",\\"html\\":\\"<h2>Step #1<\\\\\\/h2>\\",\\"hidden\\":\\"0\\",\\"columns\\":\\"6\\"}","position":"9"},"113":{"id":"113","f_id":"11","e_id":"7","data":"{\\"e_id\\":\\"7\\",\\"name\\":\\"Numbers\\",\\"label\\":\\"Numbers\\",\\"required\\":\\"0\\",\\"calculate_enabled\\":\\"1\\",\\"factor\\":\\"\\",\\"value\\":\\"\\",\\"value_external\\":\\"\\",\\"min\\":\\"0\\",\\"max\\":\\"100\\",\\"slider\\":\\"0\\",\\"steps_slider\\":\\"1\\",\\"spinner\\":\\"0\\",\\"steps_spinner\\":\\"1\\",\\"calculate\\":[{\\"operator\\":\\"0\\",\\"target\\":\\"0\\",\\"value\\":\\"\\"}],\\"overwrite_price\\":\\"0\\",\\"calculate_before\\":\\"0\\",\\"conditional\\":[{\\"action\\":\\"show\\",\\"target\\":\\"7\\",\\"operator\\":\\"between\\",\\"value\\":\\"10:100\\"}],\\"discount\\":[{\\"range_min\\":\\"\\",\\"range_max\\":\\"\\",\\"operator\\":\\"0\\",\\"discount_value\\":\\"\\"}],\\"placeholder\\":\\"\\",\\"class\\":\\"\\",\\"hidden\\":\\"0\\",\\"columns\\":\\"6\\"}","position":"8"},"115":{"id":"115","f_id":"11","e_id":"12","data":"{\\"e_id\\":\\"12\\",\\"name\\":\\"HTML\\",\\"html\\":\\"Pekaboo\\",\\"hidden\\":\\"1\\",\\"columns\\":\\"6\\"}","position":"7"},"129":{"id":"129","f_id":"11","e_id":"19","data":"{\\"e_id\\":\\"19\\",\\"name\\":\\"Step end\\",\\"previous_step\\":\\"Previous Step\\",\\"next_step\\":\\"Next Step\\",\\"columns\\":\\"6\\"}","position":"6"},"128":{"id":"128","f_id":"11","e_id":"18","data":"{\\"e_id\\":\\"18\\",\\"name\\":\\"Step\\",\\"class\\":\\"\\",\\"columns\\":\\"6\\"}","position":"5"},"133":{"id":"133","f_id":"11","e_id":"12","data":"{\\"e_id\\":\\"12\\",\\"name\\":\\"HTML\\",\\"html\\":\\"<h2>Step #2<\\\\\\/h2>\\",\\"hidden\\":\\"0\\",\\"columns\\":\\"6\\"}","position":"4"},"117":{"id":"117","f_id":"11","e_id":"8","data":"{\\"e_id\\":\\"8\\",\\"name\\":\\"Datepicker\\",\\"label\\":\\"Datepicker\\",\\"required\\":\\"0\\",\\"value\\":\\"\\",\\"value_external\\":\\"\\",\\"placeholder\\":\\"\\",\\"class\\":\\"\\",\\"hidden\\":\\"0\\",\\"columns\\":\\"6\\"}","position":"3"},"118":{"id":"118","f_id":"11","e_id":"17","data":"{\\"e_id\\":\\"17\\",\\"name\\":\\"Timepicker\\",\\"label\\":\\"Timepicker\\",\\"required\\":\\"0\\",\\"value\\":\\"\\",\\"value_external\\":\\"\\",\\"placeholder\\":\\"\\",\\"class\\":\\"\\",\\"hidden\\":\\"0\\",\\"columns\\":\\"6\\"}","position":"2"},"130":{"id":"130","f_id":"11","e_id":"19","data":"{\\"e_id\\":\\"19\\",\\"name\\":\\"Step end\\",\\"previous_step\\":\\"Previous Step\\",\\"next_step\\":\\"Next Step\\",\\"columns\\":\\"6\\"}","position":"1"}}', ''),
  (100, 'Nested Calculation', '{"53":{"id":"53","f_id":"3","e_id":"12","data":"{\\"e_id\\":\\"12\\",\\"name\\":\\"HTML\\",\\"html\\":\\"price = a1 + (a2 * x * b - a3)\\",\\"hidden\\":\\"0\\",\\"columns\\":\\"6\\"}","position":"9"},"54":{"id":"54","f_id":"3","e_id":"7","data":"{\\"e_id\\":\\"7\\",\\"name\\":\\"a1\\",\\"label\\":\\"a1\\",\\"required\\":\\"0\\",\\"calculate_enabled\\":\\"1\\",\\"is_currency\\":\\"1\\",\\"factor\\":\\"\\",\\"value\\":\\"45\\",\\"value_external\\":\\"\\",\\"min\\":\\"0\\",\\"max\\":\\"100\\",\\"slider\\":\\"0\\",\\"steps_slider\\":\\"1\\",\\"spinner\\":\\"0\\",\\"steps_spinner\\":\\"1\\",\\"calculate\\":[{\\"operator\\":\\"0\\",\\"target\\":\\"0\\",\\"value\\":\\"\\"}],\\"overwrite_price\\":\\"0\\",\\"calculate_before\\":\\"0\\",\\"conditional\\":[{\\"action\\":\\"0\\",\\"target\\":\\"0\\",\\"operator\\":\\"0\\",\\"value\\":\\"\\"}],\\"discount\\":[{\\"range_min\\":\\"\\",\\"range_max\\":\\"\\",\\"operator\\":\\"0\\",\\"discount_value\\":\\"\\"}],\\"placeholder\\":\\"\\",\\"show_in_email\\":\\"1\\",\\"class\\":\\"\\",\\"style\\":\\"\\",\\"hidden\\":\\"0\\",\\"columns\\":\\"1\\"}","position":"8"},"55":{"id":"55","f_id":"3","e_id":"7","data":"{\\"e_id\\":\\"7\\",\\"name\\":\\"a2\\",\\"label\\":\\"a2\\",\\"required\\":\\"0\\",\\"calculate_enabled\\":\\"1\\",\\"is_currency\\":\\"1\\",\\"factor\\":\\"\\",\\"value\\":\\"22.5\\",\\"value_external\\":\\"\\",\\"min\\":\\"0\\",\\"max\\":\\"100\\",\\"slider\\":\\"0\\",\\"steps_slider\\":\\"1\\",\\"spinner\\":\\"0\\",\\"steps_spinner\\":\\"1\\",\\"calculate\\":[{\\"operator\\":\\"0\\",\\"target\\":\\"0\\",\\"value\\":\\"\\"}],\\"overwrite_price\\":\\"0\\",\\"calculate_before\\":\\"0\\",\\"conditional\\":[{\\"action\\":\\"0\\",\\"target\\":\\"0\\",\\"operator\\":\\"0\\",\\"value\\":\\"\\"}],\\"discount\\":[{\\"range_min\\":\\"\\",\\"range_max\\":\\"\\",\\"operator\\":\\"0\\",\\"discount_value\\":\\"\\"}],\\"placeholder\\":\\"\\",\\"show_in_email\\":\\"1\\",\\"class\\":\\"\\",\\"style\\":\\"\\",\\"hidden\\":\\"0\\",\\"columns\\":\\"1\\"}","position":"7"},"56":{"id":"56","f_id":"3","e_id":"7","data":"{\\"e_id\\":\\"7\\",\\"name\\":\\"x\\",\\"label\\":\\"x\\",\\"required\\":\\"0\\",\\"calculate_enabled\\":\\"1\\",\\"is_currency\\":\\"1\\",\\"factor\\":\\"\\",\\"value\\":\\"1\\",\\"value_external\\":\\"\\",\\"min\\":\\"0\\",\\"max\\":\\"100\\",\\"slider\\":\\"0\\",\\"steps_slider\\":\\"1\\",\\"spinner\\":\\"0\\",\\"steps_spinner\\":\\"1\\",\\"calculate\\":[{\\"operator\\":\\"0\\",\\"target\\":\\"0\\",\\"value\\":\\"\\"}],\\"overwrite_price\\":\\"0\\",\\"calculate_before\\":\\"0\\",\\"conditional\\":[{\\"action\\":\\"0\\",\\"target\\":\\"0\\",\\"operator\\":\\"0\\",\\"value\\":\\"\\"}],\\"discount\\":[{\\"range_min\\":\\"\\",\\"range_max\\":\\"\\",\\"operator\\":\\"0\\",\\"discount_value\\":\\"\\"}],\\"placeholder\\":\\"\\",\\"show_in_email\\":\\"1\\",\\"class\\":\\"\\",\\"style\\":\\"\\",\\"hidden\\":\\"0\\",\\"columns\\":\\"1\\"}","position":"6"},"57":{"id":"57","f_id":"3","e_id":"7","data":"{\\"e_id\\":\\"7\\",\\"name\\":\\"b\\",\\"label\\":\\"b\\",\\"required\\":\\"0\\",\\"calculate_enabled\\":\\"1\\",\\"is_currency\\":\\"1\\",\\"factor\\":\\"\\",\\"value\\":\\"2\\",\\"value_external\\":\\"\\",\\"min\\":\\"0\\",\\"max\\":\\"100\\",\\"slider\\":\\"0\\",\\"steps_slider\\":\\"1\\",\\"spinner\\":\\"0\\",\\"steps_spinner\\":\\"1\\",\\"calculate\\":[{\\"operator\\":\\"0\\",\\"target\\":\\"0\\",\\"value\\":\\"\\"}],\\"overwrite_price\\":\\"0\\",\\"calculate_before\\":\\"0\\",\\"conditional\\":[{\\"action\\":\\"0\\",\\"target\\":\\"0\\",\\"operator\\":\\"0\\",\\"value\\":\\"\\"}],\\"discount\\":[{\\"range_min\\":\\"\\",\\"range_max\\":\\"\\",\\"operator\\":\\"0\\",\\"discount_value\\":\\"\\"}],\\"placeholder\\":\\"\\",\\"show_in_email\\":\\"1\\",\\"class\\":\\"\\",\\"style\\":\\"\\",\\"hidden\\":\\"0\\",\\"columns\\":\\"1\\"}","position":"5"},"58":{"id":"58","f_id":"3","e_id":"7","data":"{\\"e_id\\":\\"7\\",\\"name\\":\\"a3\\",\\"label\\":\\"a3\\",\\"required\\":\\"0\\",\\"calculate_enabled\\":\\"1\\",\\"is_currency\\":\\"1\\",\\"factor\\":\\"\\",\\"value\\":\\"1\\",\\"value_external\\":\\"\\",\\"min\\":\\"\\",\\"max\\":\\"\\",\\"slider\\":\\"0\\",\\"steps_slider\\":\\"1\\",\\"spinner\\":\\"0\\",\\"steps_spinner\\":\\"1\\",\\"calculate\\":[{\\"operator\\":\\"0\\",\\"target\\":\\"0\\",\\"value\\":\\"\\"}],\\"overwrite_price\\":\\"0\\",\\"calculate_before\\":\\"0\\",\\"conditional\\":[{\\"action\\":\\"0\\",\\"target\\":\\"0\\",\\"operator\\":\\"0\\",\\"value\\":\\"\\"}],\\"discount\\":[{\\"range_min\\":\\"\\",\\"range_max\\":\\"\\",\\"operator\\":\\"0\\",\\"discount_value\\":\\"\\"}],\\"placeholder\\":\\"\\",\\"show_in_email\\":\\"1\\",\\"class\\":\\"\\",\\"style\\":\\"\\",\\"hidden\\":\\"0\\",\\"columns\\":\\"1\\"}","position":"4"},"59":{"id":"59","f_id":"3","e_id":"11","data":"{\\"e_id\\":\\"11\\",\\"class\\":\\"\\",\\"style\\":\\"\\",\\"hidden\\":\\"0\\",\\"columns\\":\\"6\\"}","position":"3"},"60":{"id":"60","f_id":"3","e_id":"15","data":"{\\"e_id\\":\\"15\\",\\"name\\":\\"Nested Subtotal\\",\\"label\\":\\"Nested Subtotal\\",\\"calculate_enabled\\":\\"1\\",\\"is_currency\\":\\"1\\",\\"overwrite_price\\":\\"1\\",\\"calculate\\":[{\\"operator\\":\\"equals\\",\\"target\\":\\"7\\",\\"value\\":\\"\\"},{\\"operator\\":\\"multiply\\",\\"target\\":\\"6\\",\\"value\\":\\"\\"},{\\"operator\\":\\"multiply\\",\\"target\\":\\"5\\",\\"value\\":\\"\\"},{\\"operator\\":\\"subtract\\",\\"target\\":\\"4\\",\\"value\\":\\"\\"}],\\"conditional\\":[{\\"action\\":\\"0\\",\\"target\\":\\"0\\",\\"operator\\":\\"0\\",\\"value\\":\\"\\"}],\\"discount\\":[{\\"range_min\\":\\"\\",\\"range_max\\":\\"\\",\\"operator\\":\\"0\\",\\"discount_value\\":\\"\\"}],\\"text_only\\":\\"0\\",\\"show_in_email\\":\\"1\\",\\"class\\":\\"\\",\\"style\\":\\"\\",\\"hidden\\":\\"1\\",\\"columns\\":\\"3\\"}","position":"2"},"61":{"id":"61","f_id":"3","e_id":"15","data":"{\\"e_id\\":\\"15\\",\\"name\\":\\"Overall Calculation\\",\\"label\\":\\"Overall Calculation\\",\\"calculate_enabled\\":\\"1\\",\\"is_currency\\":\\"1\\",\\"overwrite_price\\":\\"1\\",\\"calculate\\":[{\\"operator\\":\\"equals\\",\\"target\\":\\"8\\",\\"value\\":\\"\\"},{\\"operator\\":\\"add\\",\\"target\\":\\"2\\",\\"value\\":\\"\\"}],\\"conditional\\":[{\\"action\\":\\"0\\",\\"target\\":\\"0\\",\\"operator\\":\\"0\\",\\"value\\":\\"\\"}],\\"discount\\":[{\\"range_min\\":\\"\\",\\"range_max\\":\\"\\",\\"operator\\":\\"0\\",\\"discount_value\\":\\"\\"}],\\"text_only\\":\\"0\\",\\"show_in_email\\":\\"1\\",\\"class\\":\\"\\",\\"style\\":\\"\\",\\"hidden\\":\\"1\\",\\"columns\\":\\"3\\"}","position":"1"}}', ''),
  (101, 'Checkbox Conditional Example', '{"241":{"id":"241","f_id":"15","e_id":"6","data":"{\\"e_id\\":\\"6\\",\\"name\\":\\"Checkbox\\",\\"label\\":\\"Checkbox\\",\\"required\\":\\"0\\",\\"calculate_enabled\\":\\"1\\",\\"is_currency\\":\\"1\\",\\"options\\":[{\\"value\\":\\"1\\",\\"text\\":\\"Show Option 1\\"},{\\"value\\":\\"2\\",\\"text\\":\\"Show Option 2\\"},{\\"value\\":\\"4\\",\\"text\\":\\"Show Option 3\\"},{\\"value\\":\\"8\\",\\"text\\":\\"Show Option 4\\"}],\\"preselect\\":\\"\\",\\"calculate\\":[{\\"operator\\":\\"0\\",\\"target\\":\\"0\\",\\"value\\":\\"\\"}],\\"overwrite_price\\":\\"0\\",\\"calculate_before\\":\\"0\\",\\"conditional\\":[{\\"action\\":\\"show\\",\\"target\\":\\"4\\",\\"operator\\":\\"bit_and\\",\\"value\\":\\"1\\"},{\\"action\\":\\"show\\",\\"target\\":\\"3\\",\\"operator\\":\\"bit_and\\",\\"value\\":\\"2\\"},{\\"action\\":\\"show\\",\\"target\\":\\"2\\",\\"operator\\":\\"bit_and\\",\\"value\\":\\"4\\"},{\\"action\\":\\"show\\",\\"target\\":\\"1\\",\\"operator\\":\\"bit_and\\",\\"value\\":\\"8\\"}],\\"discount\\":[{\\"range_min\\":\\"\\",\\"range_max\\":\\"\\",\\"operator\\":\\"0\\",\\"discount_value\\":\\"\\"}],\\"show_in_email\\":\\"1\\",\\"class\\":\\"\\",\\"style\\":\\"\\",\\"hidden\\":\\"0\\",\\"columns\\":\\"6\\"}","position":"5"},"242":{"id":"242","f_id":"15","e_id":"4","data":"{\\"e_id\\":\\"4\\",\\"name\\":\\"Option 1\\",\\"label\\":\\"Option 1\\",\\"required\\":\\"0\\",\\"calculate_enabled\\":\\"1\\",\\"is_currency\\":\\"1\\",\\"options\\":[{\\"value\\":\\"0\\",\\"text\\":\\"Option 1-1\\"},{\\"value\\":\\"1\\",\\"text\\":\\"Option 1-2\\"}],\\"calculate\\":[{\\"operator\\":\\"0\\",\\"target\\":\\"0\\",\\"value\\":\\"\\"}],\\"overwrite_price\\":\\"0\\",\\"calculate_before\\":\\"0\\",\\"conditional\\":[{\\"action\\":\\"0\\",\\"target\\":\\"0\\",\\"operator\\":\\"0\\",\\"value\\":\\"\\"}],\\"discount\\":[{\\"range_min\\":\\"\\",\\"range_max\\":\\"\\",\\"operator\\":\\"0\\",\\"discount_value\\":\\"\\"}],\\"show_in_email\\":\\"1\\",\\"class\\":\\"\\",\\"style\\":\\"\\",\\"hidden\\":\\"1\\",\\"columns\\":\\"6\\"}","position":"4"},"243":{"id":"243","f_id":"15","e_id":"4","data":"{\\"e_id\\":\\"4\\",\\"name\\":\\"Option 2\\",\\"label\\":\\"Option 2\\",\\"required\\":\\"0\\",\\"calculate_enabled\\":\\"1\\",\\"is_currency\\":\\"1\\",\\"options\\":[{\\"value\\":\\"0\\",\\"text\\":\\"Option 2-1\\"},{\\"value\\":\\"1\\",\\"text\\":\\"Option 2-2\\"}],\\"calculate\\":[{\\"operator\\":\\"0\\",\\"target\\":\\"0\\",\\"value\\":\\"\\"}],\\"overwrite_price\\":\\"0\\",\\"calculate_before\\":\\"0\\",\\"conditional\\":[{\\"action\\":\\"0\\",\\"target\\":\\"0\\",\\"operator\\":\\"0\\",\\"value\\":\\"\\"}],\\"discount\\":[{\\"range_min\\":\\"\\",\\"range_max\\":\\"\\",\\"operator\\":\\"0\\",\\"discount_value\\":\\"\\"}],\\"show_in_email\\":\\"1\\",\\"class\\":\\"\\",\\"style\\":\\"\\",\\"hidden\\":\\"1\\",\\"columns\\":\\"6\\"}","position":"3"},"244":{"id":"244","f_id":"15","e_id":"4","data":"{\\"e_id\\":\\"4\\",\\"name\\":\\"Option 3\\",\\"label\\":\\"Option 3\\",\\"required\\":\\"0\\",\\"calculate_enabled\\":\\"1\\",\\"is_currency\\":\\"1\\",\\"options\\":[{\\"value\\":\\"0\\",\\"text\\":\\"Option 3-1\\"},{\\"value\\":\\"1\\",\\"text\\":\\"Option 3-2\\"}],\\"calculate\\":[{\\"operator\\":\\"0\\",\\"target\\":\\"0\\",\\"value\\":\\"\\"}],\\"overwrite_price\\":\\"0\\",\\"calculate_before\\":\\"0\\",\\"conditional\\":[{\\"action\\":\\"0\\",\\"target\\":\\"0\\",\\"operator\\":\\"0\\",\\"value\\":\\"\\"}],\\"discount\\":[{\\"range_min\\":\\"\\",\\"range_max\\":\\"\\",\\"operator\\":\\"0\\",\\"discount_value\\":\\"\\"}],\\"show_in_email\\":\\"1\\",\\"class\\":\\"\\",\\"style\\":\\"\\",\\"hidden\\":\\"1\\",\\"columns\\":\\"6\\"}","position":"2"},"245":{"id":"245","f_id":"15","e_id":"4","data":"{\\"e_id\\":\\"4\\",\\"name\\":\\"Option 4\\",\\"label\\":\\"Option 4\\",\\"required\\":\\"0\\",\\"calculate_enabled\\":\\"1\\",\\"is_currency\\":\\"1\\",\\"options\\":[{\\"value\\":\\"0\\",\\"text\\":\\"Option 4-1\\"},{\\"value\\":\\"1\\",\\"text\\":\\"Option 4-2\\"}],\\"calculate\\":[{\\"operator\\":\\"0\\",\\"target\\":\\"0\\",\\"value\\":\\"\\"}],\\"overwrite_price\\":\\"0\\",\\"calculate_before\\":\\"0\\",\\"conditional\\":[{\\"action\\":\\"0\\",\\"target\\":\\"0\\",\\"operator\\":\\"0\\",\\"value\\":\\"\\"}],\\"discount\\":[{\\"range_min\\":\\"\\",\\"range_max\\":\\"\\",\\"operator\\":\\"0\\",\\"discount_value\\":\\"\\"}],\\"show_in_email\\":\\"1\\",\\"class\\":\\"\\",\\"style\\":\\"\\",\\"hidden\\":\\"1\\",\\"columns\\":\\"6\\"}","position":"1"}}', ''),
  (102, 'Tax Example', '{"255":{"id":"255","f_id":"17","e_id":"4","data":"{\\"e_id\\":\\"4\\",\\"name\\":\\"Dropdown\\",\\"label\\":\\"Dropdown\\",\\"required\\":\\"0\\",\\"calculate_enabled\\":\\"1\\",\\"is_currency\\":\\"1\\",\\"options\\":[{\\"value\\":\\"10\\",\\"text\\":\\"Option 0 ($10)\\"},{\\"value\\":\\"20\\",\\"text\\":\\"Option 1 ($20)\\"}],\\"calculate\\":[{\\"operator\\":\\"0\\",\\"target\\":\\"0\\",\\"value\\":\\"\\"}],\\"overwrite_price\\":\\"0\\",\\"calculate_before\\":\\"0\\",\\"conditional\\":[{\\"action\\":\\"hide\\",\\"target\\":\\"0\\",\\"operator\\":\\"equals\\",\\"value\\":\\"1\\"}],\\"discount\\":[{\\"range_min\\":\\"\\",\\"range_max\\":\\"\\",\\"operator\\":\\"0\\",\\"discount_value\\":\\"\\"}],\\"show_in_email\\":\\"1\\",\\"class\\":\\"\\",\\"style\\":\\"\\",\\"hidden\\":\\"0\\",\\"columns\\":\\"6\\"}","position":"3"},"256":{"id":"256","f_id":"17","e_id":"7","data":"{\\"e_id\\":\\"7\\",\\"name\\":\\"Numbers\\",\\"label\\":\\"Numbers\\",\\"required\\":\\"0\\",\\"calculate_enabled\\":\\"1\\",\\"is_currency\\":\\"1\\",\\"factor\\":\\"\\",\\"value\\":\\"\\",\\"value_external\\":\\"\\",\\"min\\":\\"0\\",\\"max\\":\\"100\\",\\"slider\\":\\"0\\",\\"steps_slider\\":\\"1\\",\\"spinner\\":\\"0\\",\\"steps_spinner\\":\\"1\\",\\"calculate\\":[{\\"operator\\":\\"0\\",\\"target\\":\\"0\\",\\"value\\":\\"\\"}],\\"overwrite_price\\":\\"0\\",\\"calculate_before\\":\\"0\\",\\"conditional\\":[{\\"action\\":\\"0\\",\\"target\\":\\"0\\",\\"operator\\":\\"0\\",\\"value\\":\\"\\"}],\\"discount\\":[{\\"range_min\\":\\"\\",\\"range_max\\":\\"\\",\\"operator\\":\\"0\\",\\"discount_value\\":\\"\\"}],\\"placeholder\\":\\"\\",\\"show_in_email\\":\\"1\\",\\"class\\":\\"\\",\\"style\\":\\"\\",\\"hidden\\":\\"0\\",\\"columns\\":\\"6\\"}","position":"2"},"259":{"id":"259","f_id":"17","e_id":"15","data":"{\\"e_id\\":\\"15\\",\\"name\\":\\"20% Tax\\",\\"label\\":\\"20% Tax\\",\\"calculate_enabled\\":\\"1\\",\\"is_currency\\":\\"1\\",\\"overwrite_price\\":\\"0\\",\\"calculate\\":[{\\"operator\\":\\"multiply\\",\\"target\\":\\"0\\",\\"value\\":\\"0.2\\"}],\\"conditional\\":[{\\"action\\":\\"0\\",\\"target\\":\\"0\\",\\"operator\\":\\"0\\",\\"value\\":\\"\\"}],\\"discount\\":[{\\"range_min\\":\\"\\",\\"range_max\\":\\"\\",\\"operator\\":\\"0\\",\\"discount_value\\":\\"\\"}],\\"text_only\\":\\"1\\",\\"show_in_email\\":\\"1\\",\\"class\\":\\"\\",\\"style\\":\\"\\",\\"hidden\\":\\"0\\",\\"columns\\":\\"6\\"}","position":"1"}}', ''),
  (103, 'Conditional Set Example', '{"527":{"id":"527","f_id":"49","e_id":"12","data":"{\\"e_id\\":\\"12\\",\\"name\\":\\"HTML\\",\\"html\\":\\"In this example, you can see how elements can conditionally set other values. This is useful if you want to restrict certain element values to be changed by the user.\\\\r\\\\n\\\\r\\\\nSubtotal values cannot be set since these elements are calculated separately.\\\\r\\\\n\\\\r\\\\n&lt;strong&gt;Please note that target values cannot be changed by the user this way!&lt;\\\\\\/strong&gt;\\",\\"show_in_email\\":\\"1\\",\\"hidden\\":\\"0\\",\\"columns\\":\\"6\\"}","position":"6"},"522":{"id":"522","f_id":"49","e_id":"4","data":"{\\"e_id\\":\\"4\\",\\"name\\":\\"Set values\\",\\"label\\":\\"Set values\\",\\"required\\":\\"0\\",\\"calculate_enabled\\":\\"0\\",\\"is_currency\\":\\"0\\",\\"options\\":[{\\"value\\":\\"1\\",\\"text\\":\\"10\\"},{\\"value\\":\\"2\\",\\"text\\":\\"20\\"},{\\"value\\":\\"3\\",\\"text\\":\\"30\\"}],\\"calculate\\":[{\\"operator\\":\\"0\\",\\"target\\":\\"0\\",\\"value\\":\\"\\"}],\\"overwrite_price\\":\\"0\\",\\"calculate_before\\":\\"0\\",\\"conditional\\":[{\\"action\\":\\"set\\",\\"target\\":\\"4\\",\\"target_value\\":\\"10\\",\\"operator\\":\\"equals\\",\\"value\\":\\"1\\"},{\\"action\\":\\"set\\",\\"target\\":\\"4\\",\\"target_value\\":\\"20\\",\\"operator\\":\\"equals\\",\\"value\\":\\"2\\"},{\\"action\\":\\"set\\",\\"target\\":\\"4\\",\\"target_value\\":\\"30\\",\\"operator\\":\\"equals\\",\\"value\\":\\"3\\"},{\\"action\\":\\"set\\",\\"target\\":\\"3\\",\\"target_value\\":\\"10\\",\\"operator\\":\\"equals\\",\\"value\\":\\"1\\"},{\\"action\\":\\"set\\",\\"target\\":\\"3\\",\\"target_value\\":\\"20\\",\\"operator\\":\\"equals\\",\\"value\\":\\"2\\"},{\\"action\\":\\"set\\",\\"target\\":\\"3\\",\\"target_value\\":\\"30\\",\\"operator\\":\\"equals\\",\\"value\\":\\"3\\"},{\\"action\\":\\"set\\",\\"target\\":\\"2\\",\\"target_value\\":\\"10\\",\\"operator\\":\\"equals\\",\\"value\\":\\"1\\"},{\\"action\\":\\"set\\",\\"target\\":\\"2\\",\\"target_value\\":\\"20\\",\\"operator\\":\\"equals\\",\\"value\\":\\"2\\"},{\\"action\\":\\"set\\",\\"target\\":\\"2\\",\\"target_value\\":\\"30\\",\\"operator\\":\\"equals\\",\\"value\\":\\"3\\"},{\\"action\\":\\"set\\",\\"target\\":\\"1\\",\\"target_value\\":\\"10\\",\\"operator\\":\\"equals\\",\\"value\\":\\"1\\"},{\\"action\\":\\"set\\",\\"target\\":\\"1\\",\\"target_value\\":\\"20\\",\\"operator\\":\\"equals\\",\\"value\\":\\"2\\"},{\\"action\\":\\"set\\",\\"target\\":\\"1\\",\\"target_value\\":\\"30\\",\\"operator\\":\\"equals\\",\\"value\\":\\"3\\"}],\\"discount\\":[{\\"range_min\\":\\"\\",\\"range_max\\":\\"\\",\\"operator\\":\\"0\\",\\"discount_value\\":\\"\\"}],\\"show_in_email\\":\\"1\\",\\"class\\":\\"\\",\\"style\\":\\"\\",\\"hidden\\":\\"0\\",\\"columns\\":\\"6\\"}","position":"5"},"523":{"id":"523","f_id":"49","e_id":"7","data":"{\\"e_id\\":\\"7\\",\\"name\\":\\"Numbers\\",\\"label\\":\\"Numbers\\",\\"required\\":\\"0\\",\\"calculate_enabled\\":\\"1\\",\\"is_currency\\":\\"1\\",\\"factor\\":\\"\\",\\"value\\":\\"\\",\\"value_external\\":\\"\\",\\"min\\":\\"0\\",\\"max\\":\\"100\\",\\"slider\\":\\"0\\",\\"steps_slider\\":\\"1\\",\\"spinner\\":\\"0\\",\\"steps_spinner\\":\\"1\\",\\"calculate\\":[{\\"operator\\":\\"0\\",\\"target\\":\\"0\\",\\"value\\":\\"\\"}],\\"overwrite_price\\":\\"0\\",\\"calculate_before\\":\\"0\\",\\"conditional\\":[{\\"action\\":\\"0\\",\\"target\\":\\"0\\",\\"target_value\\":\\"\\",\\"operator\\":\\"0\\",\\"value\\":\\"\\"}],\\"discount\\":[{\\"range_min\\":\\"\\",\\"range_max\\":\\"\\",\\"operator\\":\\"0\\",\\"discount_value\\":\\"\\"}],\\"placeholder\\":\\"\\",\\"show_in_email\\":\\"1\\",\\"class\\":\\"\\",\\"style\\":\\"\\",\\"hidden\\":\\"0\\",\\"columns\\":\\"3\\"}","position":"4"},"524":{"id":"524","f_id":"49","e_id":"4","data":"{\\"e_id\\":\\"4\\",\\"name\\":\\"Dropdown\\",\\"label\\":\\"Dropdown\\",\\"required\\":\\"0\\",\\"calculate_enabled\\":\\"1\\",\\"is_currency\\":\\"1\\",\\"options\\":[{\\"value\\":\\"10\\",\\"text\\":\\"Option 10\\"},{\\"value\\":\\"20\\",\\"text\\":\\"Option 20\\"},{\\"value\\":\\"30\\",\\"text\\":\\"Option 30\\"}],\\"calculate\\":[{\\"operator\\":\\"0\\",\\"target\\":\\"0\\",\\"value\\":\\"\\"}],\\"overwrite_price\\":\\"0\\",\\"calculate_before\\":\\"0\\",\\"conditional\\":[{\\"action\\":\\"0\\",\\"target\\":\\"0\\",\\"target_value\\":\\"\\",\\"operator\\":\\"0\\",\\"value\\":\\"\\"}],\\"discount\\":[{\\"range_min\\":\\"\\",\\"range_max\\":\\"\\",\\"operator\\":\\"0\\",\\"discount_value\\":\\"\\"}],\\"show_in_email\\":\\"1\\",\\"class\\":\\"\\",\\"style\\":\\"\\",\\"hidden\\":\\"0\\",\\"columns\\":\\"3\\"}","position":"3"},"525":{"id":"525","f_id":"49","e_id":"5","data":"{\\"e_id\\":\\"5\\",\\"name\\":\\"Radio\\",\\"label\\":\\"Radio\\",\\"required\\":\\"0\\",\\"calculate_enabled\\":\\"1\\",\\"is_currency\\":\\"1\\",\\"options\\":[{\\"value\\":\\"10\\",\\"text\\":\\"Option 10\\"},{\\"value\\":\\"20\\",\\"text\\":\\"Option 20\\"},{\\"value\\":\\"30\\",\\"text\\":\\"Option 30\\"}],\\"calculate\\":[{\\"operator\\":\\"0\\",\\"target\\":\\"0\\",\\"value\\":\\"\\"}],\\"overwrite_price\\":\\"0\\",\\"calculate_before\\":\\"0\\",\\"conditional\\":[{\\"action\\":\\"0\\",\\"target\\":\\"0\\",\\"target_value\\":\\"\\",\\"operator\\":\\"0\\",\\"value\\":\\"\\"}],\\"discount\\":[{\\"range_min\\":\\"\\",\\"range_max\\":\\"\\",\\"operator\\":\\"0\\",\\"discount_value\\":\\"\\"}],\\"show_in_email\\":\\"1\\",\\"class\\":\\"\\",\\"style\\":\\"\\",\\"hidden\\":\\"0\\",\\"columns\\":\\"3\\"}","position":"2"},"526":{"id":"526","f_id":"49","e_id":"6","data":"{\\"e_id\\":\\"6\\",\\"name\\":\\"Checkbox\\",\\"label\\":\\"Checkbox\\",\\"required\\":\\"0\\",\\"calculate_enabled\\":\\"1\\",\\"is_currency\\":\\"1\\",\\"options\\":[{\\"value\\":\\"10\\",\\"text\\":\\"Checkbox 10\\"},{\\"value\\":\\"20\\",\\"text\\":\\"Checkbox 20\\"},{\\"value\\":\\"30\\",\\"text\\":\\"Checkbox 30\\"}],\\"preselect\\":\\"\\",\\"calculate\\":[{\\"operator\\":\\"0\\",\\"target\\":\\"0\\",\\"value\\":\\"\\"}],\\"overwrite_price\\":\\"0\\",\\"calculate_before\\":\\"0\\",\\"conditional\\":[{\\"action\\":\\"0\\",\\"target\\":\\"0\\",\\"target_value\\":\\"\\",\\"operator\\":\\"0\\",\\"value\\":\\"\\"}],\\"discount\\":[{\\"range_min\\":\\"\\",\\"range_max\\":\\"\\",\\"operator\\":\\"0\\",\\"discount_value\\":\\"\\"}],\\"show_in_email\\":\\"1\\",\\"class\\":\\"\\",\\"style\\":\\"\\",\\"hidden\\":\\"0\\",\\"columns\\":\\"3\\"}","position":"1"}}', ''),
  (104, 'Loan Calculator', '{"712":{"id":"712","f_id":"68","e_id":"7","data":"{\\"e_id\\":\\"7\\",\\"name\\":\\"Loan Amount (P)\\",\\"label\\":\\"Loan Amount (P)\\",\\"required\\":\\"0\\",\\"calculate_enabled\\":\\"1\\",\\"is_currency\\":\\"1\\",\\"factor\\":\\"\\",\\"value\\":\\"30000\\",\\"value_external\\":\\"\\",\\"min\\":\\"1000\\",\\"max\\":\\"200000\\",\\"slider\\":\\"1\\",\\"steps_slider\\":\\"1000\\",\\"spinner\\":\\"0\\",\\"steps_spinner\\":\\"1\\",\\"calculate\\":[{\\"operator\\":\\"0\\",\\"target\\":\\"0\\",\\"value\\":\\"\\"}],\\"overwrite_price\\":\\"0\\",\\"calculate_before\\":\\"0\\",\\"conditional\\":[{\\"action\\":\\"0\\",\\"target\\":\\"0\\",\\"target_value\\":\\"\\",\\"operator\\":\\"0\\",\\"value\\":\\"\\"}],\\"discount\\":[{\\"range_min\\":\\"\\",\\"range_max\\":\\"\\",\\"operator\\":\\"0\\",\\"discount_value\\":\\"\\"}],\\"placeholder\\":\\"\\",\\"show_in_email\\":\\"1\\",\\"class\\":\\"\\",\\"style\\":\\"\\",\\"hidden\\":\\"0\\",\\"columns\\":\\"6\\"}","position":"10"},"713":{"id":"713","f_id":"68","e_id":"7","data":"{\\"e_id\\":\\"7\\",\\"name\\":\\"Interest Rate (%) (J)\\",\\"label\\":\\"Interest Rate (%) (J)\\",\\"required\\":\\"0\\",\\"calculate_enabled\\":\\"1\\",\\"is_currency\\":\\"1\\",\\"factor\\":\\"\\",\\"value\\":\\"5\\",\\"value_external\\":\\"\\",\\"min\\":\\"1\\",\\"max\\":\\"100\\",\\"slider\\":\\"1\\",\\"steps_slider\\":\\"1\\",\\"spinner\\":\\"0\\",\\"steps_spinner\\":\\"1\\",\\"calculate\\":[{\\"operator\\":\\"0\\",\\"target\\":\\"0\\",\\"value\\":\\"\\"}],\\"overwrite_price\\":\\"0\\",\\"calculate_before\\":\\"0\\",\\"conditional\\":[{\\"action\\":\\"0\\",\\"target\\":\\"0\\",\\"target_value\\":\\"\\",\\"operator\\":\\"0\\",\\"value\\":\\"\\"}],\\"discount\\":[{\\"range_min\\":\\"\\",\\"range_max\\":\\"\\",\\"operator\\":\\"0\\",\\"discount_value\\":\\"\\"}],\\"placeholder\\":\\"\\",\\"show_in_email\\":\\"1\\",\\"class\\":\\"\\",\\"style\\":\\"\\",\\"hidden\\":\\"0\\",\\"columns\\":\\"6\\"}","position":"9"},"714":{"id":"714","f_id":"68","e_id":"7","data":"{\\"e_id\\":\\"7\\",\\"name\\":\\"Months (N)\\",\\"label\\":\\"Months (N)\\",\\"required\\":\\"0\\",\\"calculate_enabled\\":\\"1\\",\\"is_currency\\":\\"1\\",\\"factor\\":\\"\\",\\"value\\":\\"60\\",\\"value_external\\":\\"\\",\\"min\\":\\"12\\",\\"max\\":\\"120\\",\\"slider\\":\\"1\\",\\"steps_slider\\":\\"12\\",\\"spinner\\":\\"0\\",\\"steps_spinner\\":\\"1\\",\\"calculate\\":[{\\"operator\\":\\"0\\",\\"target\\":\\"0\\",\\"value\\":\\"\\"}],\\"overwrite_price\\":\\"0\\",\\"calculate_before\\":\\"0\\",\\"conditional\\":[{\\"action\\":\\"0\\",\\"target\\":\\"0\\",\\"target_value\\":\\"\\",\\"operator\\":\\"0\\",\\"value\\":\\"\\"}],\\"discount\\":[{\\"range_min\\":\\"\\",\\"range_max\\":\\"\\",\\"operator\\":\\"0\\",\\"discount_value\\":\\"\\"}],\\"placeholder\\":\\"\\",\\"show_in_email\\":\\"1\\",\\"class\\":\\"\\",\\"style\\":\\"\\",\\"hidden\\":\\"0\\",\\"columns\\":\\"6\\"}","position":"8"},"718":{"id":"718","f_id":"68","e_id":"15","data":"{\\"e_id\\":\\"15\\",\\"name\\":\\"Months Holder\\",\\"label\\":\\"Months Holder\\",\\"calculate_enabled\\":\\"1\\",\\"is_currency\\":\\"1\\",\\"overwrite_price\\":\\"1\\",\\"calculate_when_hidden\\":\\"1\\",\\"price_format\\":\\"\\",\\"precision\\":\\"2\\",\\"text_only\\":\\"0\\",\\"text_before\\":\\"\\",\\"text_after\\":\\"\\",\\"calculate\\":[{\\"operator\\":\\"equals\\",\\"target\\":\\"8\\",\\"value\\":\\"\\"},{\\"operator\\":\\"multiply\\",\\"target\\":\\"0\\",\\"value\\":\\"-1\\"}],\\"conditional\\":[{\\"action\\":\\"0\\",\\"target\\":\\"0\\",\\"target_value\\":\\"\\",\\"operator\\":\\"0\\",\\"value\\":\\"\\"}],\\"discount\\":[{\\"range_min\\":\\"\\",\\"range_max\\":\\"\\",\\"operator\\":\\"0\\",\\"discount_value\\":\\"\\"}],\\"show_in_email\\":\\"0\\",\\"class\\":\\"\\",\\"style\\":\\"\\",\\"hidden\\":\\"1\\",\\"columns\\":\\"2\\"}","position":"7"},"721":{"id":"721","f_id":"68","e_id":"15","data":"{\\"e_id\\":\\"15\\",\\"name\\":\\"Interest Rate Holder\\",\\"label\\":\\"Interest Rate Holder\\",\\"calculate_enabled\\":\\"1\\",\\"is_currency\\":\\"1\\",\\"overwrite_price\\":\\"1\\",\\"calculate_when_hidden\\":\\"1\\",\\"price_format\\":\\"0.000000\\",\\"precision\\":\\"6\\",\\"text_only\\":\\"0\\",\\"text_before\\":\\"\\",\\"text_after\\":\\"\\",\\"calculate\\":[{\\"operator\\":\\"equals\\",\\"target\\":\\"9\\",\\"value\\":\\"\\"},{\\"operator\\":\\"divide\\",\\"target\\":\\"0\\",\\"value\\":\\"100\\"}],\\"conditional\\":[{\\"action\\":\\"0\\",\\"target\\":\\"0\\",\\"target_value\\":\\"\\",\\"operator\\":\\"0\\",\\"value\\":\\"\\"}],\\"discount\\":[{\\"range_min\\":\\"\\",\\"range_max\\":\\"\\",\\"operator\\":\\"0\\",\\"discount_value\\":\\"\\"}],\\"show_in_email\\":\\"0\\",\\"class\\":\\"\\",\\"style\\":\\"\\",\\"hidden\\":\\"1\\",\\"columns\\":\\"2\\"}","position":"6"},"723":{"id":"723","f_id":"68","e_id":"15","data":"{\\"e_id\\":\\"15\\",\\"name\\":\\"Interest Rate Holder \\\\\\/ Month\\",\\"label\\":\\"Interest Rate Holder \\\\\\/ Month\\",\\"calculate_enabled\\":\\"1\\",\\"is_currency\\":\\"1\\",\\"overwrite_price\\":\\"1\\",\\"calculate_when_hidden\\":\\"1\\",\\"price_format\\":\\"\\",\\"precision\\":\\"6\\",\\"text_only\\":\\"0\\",\\"text_before\\":\\"\\",\\"text_after\\":\\"\\",\\"calculate\\":[{\\"operator\\":\\"equals\\",\\"target\\":\\"6\\",\\"value\\":\\"\\"},{\\"operator\\":\\"divide\\",\\"target\\":\\"0\\",\\"value\\":\\"12\\"}],\\"conditional\\":[{\\"action\\":\\"0\\",\\"target\\":\\"0\\",\\"target_value\\":\\"\\",\\"operator\\":\\"0\\",\\"value\\":\\"\\"}],\\"discount\\":[{\\"range_min\\":\\"\\",\\"range_max\\":\\"\\",\\"operator\\":\\"0\\",\\"discount_value\\":\\"\\"}],\\"show_in_email\\":\\"0\\",\\"class\\":\\"\\",\\"style\\":\\"\\",\\"hidden\\":\\"1\\",\\"columns\\":\\"2\\"}","position":"5"},"717":{"id":"717","f_id":"68","e_id":"15","data":"{\\"e_id\\":\\"15\\",\\"name\\":\\"a = (1 + J)^(-n)\\",\\"label\\":\\"a = (1 + J)^(-n)\\",\\"calculate_enabled\\":\\"1\\",\\"is_currency\\":\\"1\\",\\"overwrite_price\\":\\"1\\",\\"calculate_when_hidden\\":\\"1\\",\\"price_format\\":\\"0,0000\\",\\"precision\\":\\"6\\",\\"text_only\\":\\"0\\",\\"text_before\\":\\"\\",\\"text_after\\":\\"\\",\\"calculate\\":[{\\"operator\\":\\"equals\\",\\"target\\":\\"0\\",\\"value\\":\\"1\\"},{\\"operator\\":\\"add\\",\\"target\\":\\"5\\",\\"value\\":\\"\\"},{\\"operator\\":\\"power\\",\\"target\\":\\"7\\",\\"value\\":\\"\\"}],\\"conditional\\":[{\\"action\\":\\"0\\",\\"target\\":\\"0\\",\\"target_value\\":\\"\\",\\"operator\\":\\"0\\",\\"value\\":\\"\\"}],\\"discount\\":[{\\"range_min\\":\\"\\",\\"range_max\\":\\"\\",\\"operator\\":\\"0\\",\\"discount_value\\":\\"\\"}],\\"show_in_email\\":\\"0\\",\\"class\\":\\"\\",\\"style\\":\\"\\",\\"hidden\\":\\"1\\",\\"columns\\":\\"2\\"}","position":"4"},"724":{"id":"724","f_id":"68","e_id":"15","data":"{\\"e_id\\":\\"15\\",\\"name\\":\\"a2 = 1 - a\\",\\"label\\":\\"a2 = 1 - a\\",\\"calculate_enabled\\":\\"1\\",\\"is_currency\\":\\"1\\",\\"overwrite_price\\":\\"1\\",\\"calculate_when_hidden\\":\\"1\\",\\"price_format\\":\\"\\",\\"precision\\":\\"6\\",\\"text_only\\":\\"0\\",\\"text_before\\":\\"\\",\\"text_after\\":\\"\\",\\"calculate\\":[{\\"operator\\":\\"equals\\",\\"target\\":\\"0\\",\\"value\\":\\"1\\"},{\\"operator\\":\\"subtract\\",\\"target\\":\\"4\\",\\"value\\":\\"1\\"}],\\"conditional\\":[{\\"action\\":\\"0\\",\\"target\\":\\"0\\",\\"target_value\\":\\"\\",\\"operator\\":\\"0\\",\\"value\\":\\"\\"}],\\"discount\\":[{\\"range_min\\":\\"\\",\\"range_max\\":\\"\\",\\"operator\\":\\"0\\",\\"discount_value\\":\\"\\"}],\\"show_in_email\\":\\"0\\",\\"class\\":\\"\\",\\"style\\":\\"\\",\\"hidden\\":\\"1\\",\\"columns\\":\\"2\\"}","position":"3"},"719":{"id":"719","f_id":"68","e_id":"15","data":"{\\"e_id\\":\\"15\\",\\"name\\":\\"b = J \\\\\\/ a2\\",\\"label\\":\\"b = J \\\\\\/ a2\\",\\"calculate_enabled\\":\\"1\\",\\"is_currency\\":\\"1\\",\\"overwrite_price\\":\\"1\\",\\"calculate_when_hidden\\":\\"1\\",\\"price_format\\":\\"0,0000\\",\\"precision\\":\\"6\\",\\"text_only\\":\\"0\\",\\"text_before\\":\\"\\",\\"text_after\\":\\"\\",\\"calculate\\":[{\\"operator\\":\\"equals\\",\\"target\\":\\"5\\",\\"value\\":\\"\\"},{\\"operator\\":\\"divide\\",\\"target\\":\\"3\\",\\"value\\":\\"\\"}],\\"conditional\\":[{\\"action\\":\\"0\\",\\"target\\":\\"0\\",\\"target_value\\":\\"\\",\\"operator\\":\\"0\\",\\"value\\":\\"\\"}],\\"discount\\":[{\\"range_min\\":\\"\\",\\"range_max\\":\\"\\",\\"operator\\":\\"0\\",\\"discount_value\\":\\"\\"}],\\"show_in_email\\":\\"0\\",\\"class\\":\\"\\",\\"style\\":\\"\\",\\"hidden\\":\\"1\\",\\"columns\\":\\"2\\"}","position":"2"},"722":{"id":"722","f_id":"68","e_id":"15","data":"{\\"e_id\\":\\"15\\",\\"name\\":\\"Payment \\\\\\/ Month\\",\\"label\\":\\"Payment \\\\\\/ Month\\",\\"calculate_enabled\\":\\"1\\",\\"is_currency\\":\\"1\\",\\"overwrite_price\\":\\"1\\",\\"calculate_when_hidden\\":\\"1\\",\\"price_format\\":\\"\\",\\"precision\\":\\"6\\",\\"text_only\\":\\"0\\",\\"text_before\\":\\"\\",\\"text_after\\":\\"\\",\\"calculate\\":[{\\"operator\\":\\"equals\\",\\"target\\":\\"10\\",\\"value\\":\\"\\"},{\\"operator\\":\\"multiply\\",\\"target\\":\\"2\\",\\"value\\":\\"\\"}],\\"conditional\\":[{\\"action\\":\\"0\\",\\"target\\":\\"0\\",\\"target_value\\":\\"\\",\\"operator\\":\\"0\\",\\"value\\":\\"\\"}],\\"discount\\":[{\\"range_min\\":\\"\\",\\"range_max\\":\\"\\",\\"operator\\":\\"0\\",\\"discount_value\\":\\"\\"}],\\"show_in_email\\":\\"0\\",\\"class\\":\\"\\",\\"style\\":\\"\\",\\"hidden\\":\\"1\\",\\"columns\\":\\"6\\"}","position":"1"}}', '');

CREATE TABLE IF NOT EXISTS `__PREFIX__ezfc_files` (
	`id` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
	`f_id` INT(10) UNSIGNED NOT NULL,
	`ref_id` VARCHAR(16) NOT NULL,
	`url` VARCHAR(2048) NOT NULL,
	`file` VARCHAR(2048) NOT NULL,
	PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT COLLATE="utf8_general_ci";

CREATE TABLE IF NOT EXISTS `__PREFIX__ezfc_preview` (
  `id` INT(10) NOT NULL AUTO_INCREMENT,
  `f_id` INT(11) NOT NULL,
  `data` MEDIUMTEXT NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE INDEX `f_id` (`f_id`)
)
COLLATE='latin1_swedish_ci' ENGINE=InnoDB;

REPLACE INTO `__PREFIX__ezfc_preview` (`id`, `f_id`, `data`) VALUES
  (1, 0, '{"form":{"id":"58","name":"Wizard"},"elements":[{"id":"21","f_id":"58","e_id":"18","data":"{\\"name\\":\\"General\\",\\"title\\":\\"General\\",\\"class\\":\\"\\",\\"wrapper_class\\":\\"\\",\\"columns\\":\\"6\\",\\"group_id\\":\\"0\\",\\"e_id\\":\\"18\\"}","position":"21"},{"id":"20","f_id":"58","e_id":"2","data":"{\\"name\\":\\"form__email_recipient\\",\\"label\\":\\"Email address\\",\\"required\\":\\"0\\",\\"use_address\\":\\"0\\",\\"double_check\\":\\"0\\",\\"allow_multiple\\":\\"0\\",\\"value\\":\\"\\",\\"value_external\\":\\"\\",\\"placeholder\\":\\"your@email.com\\",\\"icon\\":\\"\\",\\"show_in_email\\":\\"1\\",\\"description\\":\\"Submissions will be sent to this email address\\",\\"class\\":\\"\\",\\"wrapper_class\\":\\"\\",\\"style\\":\\"\\",\\"wrapper_style\\":\\"\\",\\"GET\\":\\"\\",\\"hidden\\":\\"0\\",\\"columns\\":\\"6\\",\\"group_id\\":\\"0\\",\\"e_id\\":\\"2\\"}","position":"20"},{"id":"19","f_id":"58","e_id":"1","data":"{\\"name\\":\\"form__email_admin_sender\\",\\"label\\":\\"Email sender name\\",\\"required\\":\\"0\\",\\"value\\":\\"\\",\\"value_external\\":\\"\\",\\"placeholder\\":\\"Ezplugins <hello@ezplugins.de>\\",\\"icon\\":\\"\\",\\"is_telephone_nr\\":\\"0\\",\\"custom_regex\\":\\"\\",\\"custom_error_message\\":\\"\\",\\"custom_filter\\":\\"\\",\\"show_in_email\\":\\"1\\",\\"description\\":\\"Sender name in emails. Please make sure to use the correct syntax: Name <your@email.com>\\",\\"class\\":\\"\\",\\"wrapper_class\\":\\"\\",\\"style\\":\\"\\",\\"wrapper_style\\":\\"\\",\\"GET\\":\\"\\",\\"hidden\\":\\"0\\",\\"columns\\":\\"6\\",\\"group_id\\":\\"0\\",\\"e_id\\":\\"1\\"}","position":"19"},{"id":"18","f_id":"58","e_id":"1","data":"{\\"name\\":\\"form__currency\\",\\"label\\":\\"Currency\\",\\"required\\":\\"0\\",\\"value\\":\\"$\\",\\"value_external\\":\\"\\",\\"placeholder\\":\\"\\",\\"icon\\":\\"\\",\\"is_telephone_nr\\":\\"0\\",\\"custom_regex\\":\\"\\",\\"custom_error_message\\":\\"\\",\\"custom_filter\\":\\"\\",\\"show_in_email\\":\\"1\\",\\"description\\":\\"\\",\\"class\\":\\"\\",\\"wrapper_class\\":\\"\\",\\"style\\":\\"\\",\\"wrapper_style\\":\\"\\",\\"GET\\":\\"\\",\\"hidden\\":\\"0\\",\\"columns\\":\\"6\\",\\"group_id\\":\\"0\\",\\"e_id\\":\\"1\\"}","position":"18"},{"id":"17","f_id":"58","e_id":"4","data":"{\\"name\\":\\"form__currency_position\\",\\"label\\":\\"Currency position\\",\\"required\\":\\"0\\",\\"calculate_enabled\\":\\"1\\",\\"is_currency\\":\\"1\\",\\"options\\":[{\\"value\\":\\"0\\",\\"text\\":\\"Before\\"},{\\"value\\":\\"1\\",\\"text\\":\\"After\\"}],\\"calculate\\":[{\\"operator\\":\\"0\\",\\"target\\":\\"0\\",\\"value\\":\\"\\"}],\\"overwrite_price\\":\\"0\\",\\"calculate_when_hidden\\":\\"1\\",\\"calculate_before\\":\\"0\\",\\"conditional\\":[{\\"action\\":\\"0\\",\\"target\\":\\"0\\",\\"target_value\\":\\"\\",\\"operator\\":\\"0\\",\\"value\\":\\"\\",\\"redirect\\":\\"\\"}],\\"discount\\":[{\\"range_min\\":\\"\\",\\"range_max\\":\\"\\",\\"operator\\":\\"0\\",\\"discount_value\\":\\"\\"}],\\"show_in_email\\":\\"1\\",\\"description\\":\\"\\",\\"class\\":\\"\\",\\"wrapper_class\\":\\"\\",\\"style\\":\\"\\",\\"wrapper_style\\":\\"\\",\\"hidden\\":\\"0\\",\\"columns\\":\\"6\\",\\"group_id\\":\\"0\\",\\"e_id\\":\\"4\\"}","position":"17"},{"id":"16","f_id":"58","e_id":"4","data":"{\\"name\\":\\"price_format\\",\\"label\\":\\"Price format\\",\\"required\\":\\"0\\",\\"calculate_enabled\\":\\"1\\",\\"is_currency\\":\\"1\\",\\"options\\":[{\\"value\\":\\"default\\",\\"text\\":\\"Default: $1,337.99\\"},{\\"value\\":\\"eu\\",\\"text\\":\\"European: $1.337,99\\"}],\\"calculate\\":[{\\"operator\\":\\"0\\",\\"target\\":\\"0\\",\\"value\\":\\"\\"}],\\"overwrite_price\\":\\"0\\",\\"calculate_when_hidden\\":\\"1\\",\\"calculate_before\\":\\"0\\",\\"conditional\\":[{\\"action\\":\\"0\\",\\"target\\":\\"0\\",\\"target_value\\":\\"\\",\\"operator\\":\\"0\\",\\"value\\":\\"\\",\\"redirect\\":\\"\\"}],\\"discount\\":[{\\"range_min\\":\\"\\",\\"range_max\\":\\"\\",\\"operator\\":\\"0\\",\\"discount_value\\":\\"\\"}],\\"show_in_email\\":\\"1\\",\\"description\\":\\"\\",\\"class\\":\\"\\",\\"wrapper_class\\":\\"\\",\\"style\\":\\"\\",\\"wrapper_style\\":\\"\\",\\"hidden\\":\\"0\\",\\"columns\\":\\"6\\",\\"group_id\\":\\"0\\",\\"e_id\\":\\"4\\"}","position":"16"},{"id":"15","f_id":"58","e_id":"6","data":"{\\"name\\":\\"show_decimal_numbers\\",\\"label\\":\\"Always show decimal numbers\\",\\"required\\":\\"0\\",\\"calculate_enabled\\":\\"1\\",\\"is_currency\\":\\"1\\",\\"options\\":[{\\"value\\":\\"1\\",\\"text\\":\\"Yes\\",\\"image\\":\\"\\"}],\\"calculate\\":[{\\"operator\\":\\"0\\",\\"target\\":\\"0\\",\\"value\\":\\"\\"}],\\"overwrite_price\\":\\"0\\",\\"calculate_when_hidden\\":\\"1\\",\\"calculate_before\\":\\"0\\",\\"conditional\\":[{\\"action\\":\\"0\\",\\"target\\":\\"0\\",\\"target_value\\":\\"\\",\\"operator\\":\\"0\\",\\"value\\":\\"\\",\\"redirect\\":\\"\\"}],\\"discount\\":[{\\"range_min\\":\\"\\",\\"range_max\\":\\"\\",\\"operator\\":\\"0\\",\\"discount_value\\":\\"\\"}],\\"show_in_email\\":\\"1\\",\\"description\\":\\"\\",\\"max_width\\":\\"\\",\\"max_height\\":\\"\\",\\"inline\\":\\"0\\",\\"class\\":\\"\\",\\"wrapper_class\\":\\"\\",\\"style\\":\\"\\",\\"wrapper_style\\":\\"\\",\\"hidden\\":\\"0\\",\\"columns\\":\\"6\\",\\"group_id\\":\\"0\\",\\"e_id\\":\\"6\\",\\"preselect\\":\\"\\"}","position":"15"},{"id":"14","f_id":"58","e_id":"19","data":"{\\"name\\":\\"Step end\\",\\"previous_step\\":\\"Previous Step\\",\\"next_step\\":\\"Next Step\\",\\"add_line\\":\\"1\\",\\"columns\\":6,\\"group_id\\":0,\\"e_id\\":\\"19\\"}","position":"14"},{"id":"13","f_id":"58","e_id":"18","data":"{\\"name\\":\\"PayPal\\",\\"title\\":\\"PayPal\\",\\"class\\":\\"\\",\\"wrapper_class\\":\\"\\",\\"columns\\":\\"6\\",\\"group_id\\":\\"0\\",\\"e_id\\":\\"18\\"}","position":"13"},{"id":"12","f_id":"58","e_id":"6","data":"{\\"name\\":\\"global__use_paypal\\",\\"label\\":\\"Do you want to use PayPal?\\",\\"required\\":\\"0\\",\\"calculate_enabled\\":\\"1\\",\\"is_currency\\":\\"1\\",\\"options\\":[{\\"value\\":\\"1\\",\\"text\\":\\"Yes\\",\\"image\\":\\"\\"}],\\"calculate\\":[{\\"operator\\":\\"0\\",\\"target\\":\\"0\\",\\"value\\":\\"\\"}],\\"overwrite_price\\":\\"0\\",\\"calculate_when_hidden\\":\\"1\\",\\"calculate_before\\":\\"0\\",\\"conditional\\":[{\\"action\\":\\"show\\",\\"target\\":\\"11\\",\\"target_value\\":\\"\\",\\"operator\\":\\"equals\\",\\"value\\":\\"1\\",\\"redirect\\":\\"\\"}],\\"discount\\":[{\\"range_min\\":\\"\\",\\"range_max\\":\\"\\",\\"operator\\":\\"0\\",\\"discount_value\\":\\"\\"}],\\"show_in_email\\":\\"1\\",\\"description\\":\\"\\",\\"max_width\\":\\"\\",\\"max_height\\":\\"\\",\\"inline\\":\\"0\\",\\"class\\":\\"\\",\\"wrapper_class\\":\\"\\",\\"style\\":\\"\\",\\"wrapper_style\\":\\"\\",\\"hidden\\":\\"0\\",\\"columns\\":\\"6\\",\\"group_id\\":\\"0\\",\\"e_id\\":\\"6\\",\\"preselect\\":\\"\\"}","position":"12"},{"id":"11","f_id":"58","e_id":"25","data":"{\\"name\\":\\"Group\\",\\"wrapper_class\\":\\"\\",\\"wrapper_style\\":\\"\\",\\"hidden\\":\\"0\\",\\"columns\\":\\"6\\",\\"group_id\\":\\"11\\",\\"e_id\\":\\"25\\"}","position":"11"},{"id":"10","f_id":"58","e_id":"1","data":"{\\"name\\":\\"global__pp_username\\",\\"label\\":\\"PayPal API username\\",\\"required\\":\\"0\\",\\"value\\":\\"\\",\\"value_external\\":\\"\\",\\"placeholder\\":\\"\\",\\"icon\\":\\"\\",\\"is_telephone_nr\\":\\"0\\",\\"custom_regex\\":\\"\\",\\"custom_error_message\\":\\"\\",\\"custom_filter\\":\\"\\",\\"show_in_email\\":\\"1\\",\\"description\\":\\"\\",\\"class\\":\\"\\",\\"wrapper_class\\":\\"\\",\\"style\\":\\"\\",\\"wrapper_style\\":\\"\\",\\"GET\\":\\"\\",\\"hidden\\":\\"0\\",\\"columns\\":\\"6\\",\\"group_id\\":\\"11\\",\\"e_id\\":\\"1\\"}","position":"10"},{"id":"9","f_id":"58","e_id":"1","data":"{\\"name\\":\\"global__pp_password\\",\\"label\\":\\"PayPal API password\\",\\"required\\":\\"0\\",\\"value\\":\\"\\",\\"value_external\\":\\"\\",\\"placeholder\\":\\"\\",\\"icon\\":\\"\\",\\"is_telephone_nr\\":\\"0\\",\\"custom_regex\\":\\"\\",\\"custom_error_message\\":\\"\\",\\"custom_filter\\":\\"\\",\\"show_in_email\\":\\"1\\",\\"description\\":\\"\\",\\"class\\":\\"\\",\\"wrapper_class\\":\\"\\",\\"style\\":\\"\\",\\"wrapper_style\\":\\"\\",\\"GET\\":\\"\\",\\"hidden\\":\\"0\\",\\"columns\\":\\"6\\",\\"group_id\\":\\"11\\",\\"e_id\\":\\"1\\"}","position":"9"},{"id":"8","f_id":"58","e_id":"1","data":"{\\"name\\":\\"global__pp_signature\\",\\"label\\":\\"PayPal API signature\\",\\"required\\":\\"0\\",\\"value\\":\\"\\",\\"value_external\\":\\"\\",\\"placeholder\\":\\"\\",\\"icon\\":\\"\\",\\"is_telephone_nr\\":\\"0\\",\\"custom_regex\\":\\"\\",\\"custom_error_message\\":\\"\\",\\"custom_filter\\":\\"\\",\\"show_in_email\\":\\"1\\",\\"description\\":\\"\\",\\"class\\":\\"\\",\\"wrapper_class\\":\\"\\",\\"style\\":\\"\\",\\"wrapper_style\\":\\"\\",\\"GET\\":\\"\\",\\"hidden\\":\\"0\\",\\"columns\\":\\"6\\",\\"group_id\\":\\"11\\",\\"e_id\\":\\"1\\"}","position":"8"},{"id":"7","f_id":"58","e_id":"6","data":"{\\"name\\":\\"global__pp_sandbox\\",\\"label\\":\\"Use sandbox\\",\\"required\\":\\"0\\",\\"calculate_enabled\\":\\"1\\",\\"is_currency\\":\\"1\\",\\"options\\":[{\\"value\\":\\"1\\",\\"text\\":\\"Yes\\",\\"image\\":\\"\\"}],\\"calculate\\":[{\\"operator\\":\\"0\\",\\"target\\":\\"0\\",\\"value\\":\\"\\"}],\\"overwrite_price\\":\\"0\\",\\"calculate_when_hidden\\":\\"1\\",\\"calculate_before\\":\\"0\\",\\"conditional\\":[{\\"action\\":\\"show\\",\\"target\\":\\"0\\",\\"target_value\\":\\"\\",\\"operator\\":\\"equals\\",\\"value\\":\\"1\\",\\"redirect\\":\\"\\"}],\\"discount\\":[{\\"range_min\\":\\"\\",\\"range_max\\":\\"\\",\\"operator\\":\\"0\\",\\"discount_value\\":\\"\\"}],\\"show_in_email\\":\\"1\\",\\"description\\":\\"\\",\\"max_width\\":\\"\\",\\"max_height\\":\\"\\",\\"inline\\":\\"0\\",\\"class\\":\\"\\",\\"wrapper_class\\":\\"\\",\\"style\\":\\"\\",\\"wrapper_style\\":\\"\\",\\"hidden\\":\\"0\\",\\"columns\\":\\"6\\",\\"group_id\\":\\"11\\",\\"e_id\\":\\"6\\",\\"preselect\\":\\"\\"}","position":"7"},{"id":"6","f_id":"58","e_id":"12","data":"{\\"name\\":\\"Sandbox\\\\/Live\\",\\"html\\":\\"Please make sure to use the correct credentials as sandbox and live credentials are different. You can test the&nbsp;credentials on the Help \\\\/ debug page.\\",\\"show_in_email\\":\\"0\\",\\"hidden\\":\\"0\\",\\"columns\\":\\"6\\",\\"group_id\\":\\"11\\",\\"e_id\\":\\"12\\"}","position":"6"},{"id":"5","f_id":"58","e_id":"6","data":"{\\"name\\":\\"pp_create_pages\\",\\"label\\":\\"Create PayPal pages\\",\\"required\\":\\"0\\",\\"calculate_enabled\\":\\"1\\",\\"is_currency\\":\\"1\\",\\"options\\":[{\\"value\\":\\"1\\",\\"text\\":\\"Yes\\",\\"image\\":\\"\\"}],\\"calculate\\":[{\\"operator\\":\\"0\\",\\"target\\":\\"0\\",\\"value\\":\\"\\"}],\\"overwrite_price\\":\\"0\\",\\"calculate_when_hidden\\":\\"1\\",\\"calculate_before\\":\\"0\\",\\"conditional\\":[{\\"action\\":\\"show\\",\\"target\\":\\"0\\",\\"target_value\\":\\"\\",\\"operator\\":\\"equals\\",\\"value\\":\\"1\\",\\"redirect\\":\\"\\"}],\\"discount\\":[{\\"range_min\\":\\"\\",\\"range_max\\":\\"\\",\\"operator\\":\\"0\\",\\"discount_value\\":\\"\\"}],\\"show_in_email\\":\\"1\\",\\"description\\":\\"\\",\\"max_width\\":\\"\\",\\"max_height\\":\\"\\",\\"inline\\":\\"0\\",\\"class\\":\\"\\",\\"wrapper_class\\":\\"\\",\\"style\\":\\"\\",\\"wrapper_style\\":\\"\\",\\"hidden\\":\\"0\\",\\"columns\\":\\"6\\",\\"group_id\\":\\"11\\",\\"e_id\\":\\"6\\",\\"preselect\\":\\"\\"}","position":"5"},{"id":"4","f_id":"58","e_id":"12","data":"{\\"name\\":\\"Create pages info\\",\\"html\\":\\"The plugin can create all relevant PayPal sites for you automatically. The plugin will create 2 new sites with the relevant shortcodes. Please note that if you change the permalink of the pages, you need to update the pages in the global settings as well.\\",\\"show_in_email\\":\\"0\\",\\"hidden\\":\\"0\\",\\"columns\\":\\"6\\",\\"group_id\\":\\"11\\",\\"e_id\\":\\"12\\"}","position":"4"},{"id":"3","f_id":"58","e_id":"27","data":"{\\"name\\":\\"Spacer\\",\\"height\\":\\"30\\",\\"wrapper_class\\":\\"\\",\\"wrapper_style\\":\\"\\",\\"style\\":\\"\\",\\"hidden\\":\\"0\\",\\"columns\\":\\"6\\",\\"group_id\\":\\"11\\",\\"e_id\\":\\"27\\"}","position":"3"},{"id":"2","f_id":"58","e_id":"12","data":"{\\"name\\":\\"Currency Info\\",\\"html\\":\\"&lt;strong&gt;You need to&nbsp;set the currency code in the global settings manually.&lt;\\\\/strong&gt;\\",\\"show_in_email\\":\\"0\\",\\"hidden\\":\\"0\\",\\"columns\\":\\"6\\",\\"group_id\\":\\"11\\",\\"e_id\\":\\"12\\"}","position":"2"},{"id":"1","f_id":"58","e_id":"19","data":"{\\"name\\":\\"Step end\\",\\"previous_step\\":\\"Previous Step\\",\\"next_step\\":\\"Next Step\\",\\"add_line\\":\\"1\\",\\"columns\\":6,\\"group_id\\":0,\\"e_id\\":\\"19\\"}","position":"1"}],"options":{"1":{"value":"ms@roberto-gruppe.de"},"2":{"value":"Thank you for your submission!"},"3":{"value":"60"},"4":{"value":"0"},"5":{"value":"€"},"6":{"value":"Price"},"7":{"value":"0"},"8":{"value":"1"},"9":{"value":"0"},"10":{"value":""},"11":{"value":"Your submission!!"},"12":{"value":"Thank you for your submission, we will contact you soon!\\r\\n\\r\\n{{result_simple}}"},"13":{"value":"New submission"},"14":{"value":"You have received a new submission:\\r\\n\\r\\n{{result}}"},"15":{"value":"Save"},"16":{"value":"Add to cart"},"17":{"value":"ezfc-autowidth"},"18":{"value":"1"},"19":{"value":"slick"},"20":{"value":"1"},"21":{"value":"mm/dd/yy"},"22":{"value":"0"},"23":{"value":"Check out with PayPal"},"24":{"value":"Your submission"},"25":{"value":"Thank you for your submission,\\r\\n\\r\\nwe have received your payment via PayPal."},"26":{"value":"We have received your payment, thank you!"},"27":{"value":""},"28":{"value":""},"29":{"value":"Minimum submission value is %s"},"30":{"value":"0"},"31":{"value":"-1"},"32":{"value":"0"},"33":{"value":"H:i"},"34":{"value":"0,0[.]00"},"35":{"value":""},"36":{"value":"0"},"37":{"value":"0"},"38":{"value":"0"},"39":{"value":"Request price"},"40":{"value":"-"},"41":{"value":"0"},"42":{"value":""},"43":{"value":""},"44":{"value":""},"45":{"value":""},"46":{"value":"1000"},"47":{"value":"30"},"48":{"value":"0"},"49":{"value":"20"},"50":{"value":"1"},"51":{"value":".ezfc-form-58 .ezfc-element-wrapper-spacer {height:px;}"},"52":{"value":""},"53":{"value":"a:1:{s:5:\\"color\\";s:0:\\"\\";}"},"54":{"value":"a:1:{s:5:\\"color\\";s:0:\\"\\";}"},"55":{"value":"a:1:{s:5:\\"color\\";s:0:\\"\\";}"},"56":{"value":"a:1:{s:5:\\"color\\";s:0:\\"\\";}"},"57":{"value":"a:4:{s:5:\\"color\\";s:0:\\"\\";s:5:\\"width\\";s:0:\\"\\";s:5:\\"style\\";s:4:\\"none\\";s:6:\\"radius\\";s:0:\\"\\";}"},"58":{"value":""},"59":{"value":"a:2:{s:5:\\"value\\";s:0:\\"\\";s:4:\\"unit\\";s:2:\\"px\\";}"},"60":{"value":""},"61":{"value":"a:1:{s:5:\\"color\\";s:0:\\"\\";}"},"62":{"value":"a:1:{s:5:\\"color\\";s:0:\\"\\";}"},"63":{"value":"a:4:{s:5:\\"color\\";s:0:\\"\\";s:5:\\"width\\";s:0:\\"\\";s:5:\\"style\\";s:4:\\"none\\";s:6:\\"radius\\";s:0:\\"\\";}"},"64":{"value":""},"65":{"value":"a:1:{s:5:\\"color\\";s:0:\\"\\";}"},"66":{"value":"a:1:{s:5:\\"color\\";s:0:\\"\\";}"},"67":{"value":"a:4:{s:5:\\"color\\";s:0:\\"\\";s:5:\\"width\\";s:0:\\"\\";s:5:\\"style\\";s:4:\\"none\\";s:6:\\"radius\\";s:0:\\"\\";}"},"68":{"value":"a:2:{s:5:\\"value\\";s:0:\\"\\";s:4:\\"unit\\";s:2:\\"px\\";}"},"69":{"value":"a:2:{s:5:\\"value\\";s:0:\\"\\";s:4:\\"unit\\";s:2:\\"px\\";}"},"70":{"value":"a:2:{s:5:\\"value\\";s:0:\\"\\";s:4:\\"unit\\";s:2:\\"px\\";}"},"71":{"value":"a:2:{s:5:\\"value\\";s:0:\\"\\";s:4:\\"unit\\";s:2:\\"px\\";}"},"72":{"value":"a:2:{s:5:\\"value\\";s:0:\\"\\";s:4:\\"unit\\";s:2:\\"px\\";}"},"73":{"value":"a:1:{s:5:\\"color\\";s:0:\\"\\";}"},"74":{"value":"a:1:{s:5:\\"color\\";s:0:\\"\\";}"},"75":{"value":"0"},"76":{"value":"a:2:{s:7:\\"enabled\\";s:1:\\"0\\";s:4:\\"text\\";s:0:\\"\\";}"},"77":{"value":""},"78":{"value":""},"79":{"value":"0"},"80":{"value":"Summary"},"81":{"value":"Check your order"},"82":{"value":"a:2:{s:5:\\"value\\";s:0:\\"\\";s:4:\\"unit\\";s:2:\\"px\\";}"},"83":{"value":"a:1:{s:5:\\"color\\";s:0:\\"\\";}"},"84":{"value":"a:1:{s:5:\\"color\\";s:0:\\"\\";}"},"85":{"value":"a:1:{s:5:\\"color\\";s:0:\\"\\";}"},"86":{"value":"a:1:{s:5:\\"color\\";s:0:\\"\\";}"},"87":{"value":"a:1:{s:5:\\"color\\";s:0:\\"\\";}"},"88":{"value":"a:2:{s:5:\\"value\\";s:0:\\"\\";s:4:\\"unit\\";s:2:\\"px\\";}"},"89":{"value":"0"},"90":{"value":""},"91":{"value":""},"92":{"value":"Gesamt"},"93":{"value":"a:2:{s:5:\\"value\\";s:0:\\"\\";s:4:\\"unit\\";s:2:\\"px\\";}"},"94":{"value":"0"},"95":{"value":"0"},"96":{"value":"0"},"97":{"value":"0"},"98":{"value":"0"},"99":{"value":"0"},"100":{"value":"1"},"101":{"value":"Step %d"},"102":{"value":"1"},"103":{"value":"1"},"104":{"value":"0"},"105":{"value":"0"}},"version":"2.9.4.0"}');