<?php

defined( 'ABSPATH' ) OR exit;

require_once(EZFC_PATH . "class.ezfc_backend.php");
$ezfc = new Ezfc_backend();
$message = "";

$global_settings = Ezfc_settings::get_global_settings(true);

// clear logs
if (isset($_REQUEST["clear_logs"]) && $_REQUEST["clear_logs"] == 1) {
	$ezfc->clear_debug_log();
	$message = __("Logs cleared.", "ezfc");
}

// send test mail
if (!empty($_REQUEST["send_test_mail"]) && !empty($_REQUEST["send_test_mail_recipient"])) {
	$message = $ezfc->send_test_mail($_REQUEST["send_test_mail_recipient"]);
}

// paypal test
if (!empty($_REQUEST["paypal_test"])) {
	// cURL not installed
	if (!function_exists("curl_version")) {
		$message = __("cURL is not installed on your webserver. Please contact your webhoster to install this module in order to use PayPal.", "ezfc");
	}
	else {
		$test_url_base = $_REQUEST["paypal_env"]=="live" ? "https://api-3t.paypal.com/nvp" : "https://api-3t.sandbox.paypal.com/nvp";

		$test_query = http_build_query(array(
			"USER"                           => get_option("ezfc_pp_api_username"),
			"PWD"                            => get_option("ezfc_pp_api_password"),
			"SIGNATURE"                      => get_option("ezfc_pp_api_signature"),
			"VERSION"                        => "104.0",
			"method"                         => "SetExpressCheckout",
			"PAYMENTREQUEST_0_AMT"           => "10.00",
			"PAYMENTREQUEST_0_CURRENCYCODE"  => "USD",
			"PAYMENTREQUEST_0_PAYMENTACTION" => "Sale",
			"returnUrl"    	                 => "http://www.paypal.com/test.php",
			"cancelUrl"    	                 => "http://www.paypal.com/test.php",
			"L_PAYMENTREQUEST_0_NAME0"       => "item",
	 		"L_PAYMENTREQUEST_0_AMT0"        => "10.00",
	 		"L_PAYMENTREQUEST_0_QTY0"        => "1"
		));

		$test_url = $test_url_base . "?" . $test_query;

		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $test_url);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);	
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
		curl_setopt($ch, CURLOPT_HEADER, false);
		$res = curl_exec($ch);
		curl_close($ch);

		parse_str($res, $test_result);
		if (!empty($test_result["ACK"]) && $test_result["ACK"] == "Success") {
			$message = sprintf(__("PayPal successfully verified your %s credentials.", "ezfc"), "<strong>{$_REQUEST["paypal_env"]}</strong>");
		}
		else {
			$message  = sprintf(__("Error while validating %s credentials:", "ezfc"), "<strong>{$_REQUEST["paypal_env"]}</strong>");
			$message .= $test_result["L_LONGMESSAGE0"] . "<br><br>";
			$message .= sprintf(__("Please note that Sandbox API credentials are different! See %s to read how to get your API credentials.", "ezfc"), "<a href='https://developer.paypal.com/docs/classic/api/apiCredentials/'>PayPal docs</a>");
		}

		// check for valid URLs
		$check_empty = array(
			"PayPal Username" => get_option("ezfc_pp_api_username"),
			"PayPal Password" => get_option("ezfc_pp_api_password"),
			"PayPal Signature" => get_option("ezfc_pp_api_signature"),
			"PayPal Return URL" => $global_settings["pp_return_url"]["value"],
			"PayPal Cancel URL" => $global_settings["pp_cancel_url"]["value"],
			"PayPal Currency Code" => $global_settings["pp_currency_code"]["value"]
		);

		foreach ($check_empty as $option_name => $option_value) {
			if (empty($option_value)) {
				$message .= "<br>" . sprintf(__("Empty %s", "ezfc"), $option_name);
			}
		}
	}
}

// create paypal sites
if (!empty($_REQUEST["paypal_create_sites"])) {
	// return page
	$post_arr = array(
		'post_type'     => 'page',
		'post_title'    => __("PayPal Return Page", "ezfc"),
		'post_content'  => '[ezfc_verify /]',
		'post_status'   => 'publish'
	);
	$post_id_return = wp_insert_post( $post_arr );

	// cancel page
	$post_arr = array(
		'post_type'     => 'page',
		'post_title'    => __("PayPal Cancel Page", "ezfc"),
		'post_content'  => __("PayPal payment was cancelled.", "ezfc"),
		'post_status'   => 'publish'
	);
	$post_id_cancel = wp_insert_post( $post_arr );

	if (empty($post_id_return) || empty($post_id_cancel)) {
		$message .= __("Unable to create PayPal pages.", "ezfc");
	}
	else {
		// update ezfc paypal options
		$post_return_url = get_permalink($post_id_return);
		$post_cancel_url = get_permalink($post_id_cancel);

		update_option("ezfc_pp_return_url", $post_return_url);
		update_option("ezfc_pp_cancel_url", $post_cancel_url);
	}
}

$debug_active = get_option("ezfc_debug_mode", 0)==1 ? true : false;
$debug_log    = $ezfc->get_debug_log();

$upload_dir      = wp_upload_dir();
$ezfc_upload_dir = $upload_dir["basedir"] . "/ezfc-uploads/";
$pdf_dir         = $upload_dir["basedir"] . "/ezfc-pdf/";
$pdf_seed        = get_option("ezfc_ext_pdf_seed");
$install_file    = EZFC_PATH . "db.sql";

$icons = array(
	"good" => "<i class='fa fa-check'></i>",
	"bad"  => "<i class='fa fa-times'></i>"
);

$debug_vars = array(
	"php_version" => array(
		"value"    => PHP_VERSION,
		"required" => "5.4.0",
		"error"    => sprintf(__("PHP version %s or greater is recommended.", "ezfc"), "5.4.0"),
		"is_version" => true
	),
	"wp_version" => array(
		"value"    => get_bloginfo("version"),
		"required" => version_compare(get_bloginfo("version"), "4.1"),
		"error"    => __("WP version 4.1 or greater is recommended.", "ezfc")
	),
	"file_get_contents" => array(
		"value"    => function_exists("file_get_contents"),
		"required" => true,
		"is_bool"  => true,
		"error"    => __("PHP function file_get_contents is disabled. Please contact your webhost to enable this function.", "ezfc")
	),
	"allow_url_fopen" => array(
		"value"    => @ini_get('allow_url_fopen'),
		"required" => true,
		"is_bool"  => true,
		"error"    => __("PHP option allow_url_fopen is disabled. Please contact your webhost to enable this option.", "ezfc")
	),
	"memory_limit" => array(
		"value"    => @ini_get('memory_limit'),
		"required" => 128,
		"error"    => __("The PHP memory limit is too low. Please contact your webhost to increase the memory limit.", "ezfc")
	),
	"file_upload_dir" => array(
		"value"    => file_exists($ezfc_upload_dir) && is_writable($ezfc_upload_dir),
		"required" => true,
		"is_bool"  => true,
		"error"    => sprintf(__("Please make sure the following directory is writeable: %s", "ezfc"), $ezfc_upload_dir)
	),
	"PDF folder" => array(
		"value" => file_exists($pdf_dir) && is_writable($pdf_dir),
		"required" => true,
		"is_bool"  => true,
		"error"    => sprintf(__("Please make sure the following directory is writeable: %s", "ezfc"), $pdf_dir)
	),
	"PDF seed" => array(
		"value" => !empty($pdf_seed),
		"required" => true,
		"is_bool"  => true,
		"error"    => __("Empty pdf seed. Please go to the global settings page, check the option 'Manual update' and click on save.", "ezfc")
	),
	"cURL" => array(
		"value" => function_exists("curl_version"),
		"required" => true,
		"is_bool"  => true,
		"error"    => __("cURL is not installed on your webserver. Please contact your webhost to enable this function.", "ezfc")
	),
	"Install file" => array(
		"value"    => file_exists($install_file) && is_readable($install_file),
		"required" => true,
		"is_bool"  => true,
		"error"    => sprintf(__("Please make sure the following file exists and is readable: %s", "ezfc"), $install_file)
	),
	"upload_max_filesize"   => @ini_get('upload_max_filesize'),
	"post_max_size"         => @ini_get('post_max_size')
);

?>

<div class="ezfc wrap ezfc-wrapper container-fluid">
	<div class="row">
		<div class="col-lg-12">
			<div class="inner">
				<h2><?php echo __("Help / debug", "ezfc"); ?> - ez Form Calculator v<?php echo EZFC_VERSION; ?></h2> 
				<p>
					<a class="button button-primary" href="http://ez-form-calculator.ezplugins.de/documentation/" target="_blank"><?php echo __("Open documentation site", "ezfc"); ?></a>
				</p>

				<p>
					<?php echo sprintf(__("If you have found any bugs, please report them to %s. Thank you!", "ezfc"), "<a href='mailto:support@ezplugins.de'>support@ezplugins.de</a>"); ?>
				</p>
			</div>
		</div>

		<?php if (!empty($message)) { ?>
			<div class="col-lg-12">
				<div class="inner">
					<div id="message" class="updated"><?php echo $message; ?></div>
				</div>
			</div>
		<?php } ?>
	</div>
	
	<div class="row">
		<div class="col-lg-3 col-sm-6 col-md-6 col-xs-12">
			<div class="inner">
				<h3>Debug log</h3>

				<p><?php echo sprintf(__("Debug mode is %s", "ezfc"), $debug_active ? __("active", "ezfc") : __("inactive", "ezfc")); ?>.</p>
				<textarea class="ezfc-settings-type-textarea" style="height: 400px;"><?php echo $debug_log; ?></textarea>

				<form action="" method="POST">
					<input type="hidden" value="1" name="clear_logs" />
					<input type="submit" value="Clear logs" class="button button-primary" />
				</form>
			</div>
		</div>

		<div class="col-lg-3 col-sm-6 col-md-6 col-xs-12">
			<div class="inner">
				<h3><?php echo __("Environment Vars", "ezfc"); ?></h3>

				<?php
				$out = array();
				$out[] = "<table>";
				foreach ($debug_vars as $key => $var) {
					$out[] = "<tr><td>";
					$out[] = $key;
					$out[] = "</td><td>";

					if (is_array($var)) {
						$option_success = false;
						$tmp_out = "";

						if (!empty($var["is_bool"])) {
							$option_success = (bool) $var["value"] == $var["required"];
						}
						else if (!empty($var["version"])) {
							$option_success = version_compare($var["value"], $var["required"]) >= 0;
						}
						else {
							$option_success = (float) $var["value"] >= $var["required"];
							$tmp_out = $var["value"];
						}

						$icon      = $option_success ? $icons["good"] : $icons["bad"];
						$css_class = $option_success ? "ezfc-color-success" : "ezfc-color-error";

						if (!$option_success) {
							$tmp_out .= "<br><strong>{$var["error"]}</strong>";
						}

						$out[] = "<span class='{$css_class}'>{$icon} {$tmp_out}</span>";
					}
					else {
						$out[] = $var;
					}

					$out[] = "</td></tr>";
				}
				$out[] = "</table>";

				echo implode("", $out);
				?>

				<h3><?php echo __("Tests", "ezfc"); ?></h3>

				<div>
					<strong><?php echo __("Emails", "ezfc"); ?></strong>
					<form action="" method="POST">
						<input type="hidden" value="1" name="send_test_mail" />
						<input type="text" value="" name="send_test_mail_recipient" placeholder="your@email.com" />
						<br />
						<input type="submit" value="<?php echo __("Send test mail", "ezfc"); ?>" class="button" />
					</form>
				</div>
			</div>
		</div>

		<div class="col-lg-3 col-sm-6 col-md-6 col-xs-12">
			<div class="inner">
				<h3>PayPal</h3>

				<form action="" method="POST">
					<input type="hidden" value="1" name="paypal_test" />
					<select name="paypal_env">
						<option value="live"><?php echo __("Live", "ezfc"); ?></option>
						<option value="sandbox"><?php echo __("Sandbox", "ezfc"); ?></option>
					</select>
					<br />
					<input type="submit" value="<?php echo __("Test PayPal integration", "ezfc"); ?>" class="button" />
				</form>

				<hr />

				<p><?php echo __("The plugin can create all relevant PayPal sites for you automatically. The plugin will create 2 new sites with the relevant shortcodes. Please note that if you change the permalink of the pages, you need to update the pages in the global settings as well.", "ezfc"); ?></p>

				<form action="" method="POST">
					<input type="hidden" value="1" name="paypal_create_sites" />
					<input type="submit" value="<?php echo __("Create PayPal sites", "ezfc"); ?>" class="button" />
				</form>
			</div>
		</div>

		<div class="col-lg-3 col-sm-6 col-md-6 col-xs-12">
			<a class="twitter-timeline" href="https://twitter.com/ezPlugins" data-widget-id="575319170478383104">Tweets by @ezPlugins</a>
			<script>!function(d,s,id){var js,fjs=d.getElementsByTagName(s)[0],p=/^http:/.test(d.location)?'http':'https';if(!d.getElementById(id)){js=d.createElement(s);js.id=id;js.src=p+"://platform.twitter.com/widgets.js";fjs.parentNode.insertBefore(js,fjs);}}(document,"script","twitter-wjs");</script>
		</div>
	</div>
</div>
